#include "LCD.h"

void LCD_INIT(void)
{
    
// Preload some arrays
//  char hello_world[]   ="Hello World";
    char splash_screen1[]="Group O";
    char splash_screen2[]="Plymouth UNI";
    char DVM[]           ="Voltage=";
    
    LCD_CLR();
    writeToLCD(splash_screen1,LINE1,1);    //Credit line 1
    writeToLCD(splash_screen2,LINE2,2);    //Credit line 2
    wait(2);
    LCD_CLR();  
    writeToLCD(DVM,LINE1,0);   //Type Voltage display
    writeToLCD("V",LINE1,13);   //Units display
}

void writeToLCD(char* str, int line, int pos)
{
    unsigned int length = strlen(str);
    cmdLCD(line|pos);
    
    if(pos + length <= 16)
    {
                unsigned int i;
        
        for(i=0; i<length; i++)
        {
            putLCD(str[i]);   
        }
    }
    else
    {
        unsigned int line1;
        unsigned int line2;
        
        line1 = findSpace(str);
        
        line2 = length - line1;
        
        unsigned int i;
        for(i=0; i<line1; i++)
        {
            putLCD(str[i]);   
        }
        
        cmdLCD(LINE2);
        
        if((line2 <= 16)&&(line != 2))
        {
            for(i=0; i<line2; i++)
            {
                putLCD(str[line1 + i]);
            }
        }
        else
        {
            for(i=0; i<(13); i++)
            {
                putLCD(str[line1 + i]);
            }
            
            for(i=0; i<3; i++)
            {
                putLCD('.');
            }  
        }
    }
}

void putLCD(unsigned char put)  //sends a char to the LCD display
{
    unsigned int data = WRITE|TEXT|put; //RS (text), RW (write), data (put)
    spi_write_data(CS_LCD, data);
   //spi_write_data(CS_LCD, (1<<8)+put);
    
    
        wait_us(25);
}

void cmdLCD(unsigned char cmd)      //sends a byte to the LCD control register
{
    unsigned int data = WRITE|COMMAND|cmd; //RS (command), RW (write), data (cmd)
    spi_write_data(CS_LCD, data);
        wait_us(2000);
}

unsigned int findSpace(char* str)
{
    unsigned int space = 0;
    int n = 16;
    while(!space & (n != -1))
    {
        n--;
        switch(str[n])
        {
            case ' ':
            case '.':
            case ',':
            case ':':
            case ';':
            case '-':
            case '/':
                space = 1;
            break;
        }
    }
    if(n == -1){ return 16; }
    else{ return n+1; }
}