#include "FPGA.h"
DigitalOut reset(PB_1);

void reset_board(void)
{
    reset = 1;
    wait(1);
    reset = 0;   
}

int read_switches(void){
    int sw_val;
    sw_val = spi_read_data(CS_GENERAL)&0x0F; // Just want lower 4bit nibble
    if (sw_val&(1<<0)){printf("Switch 0 :");}
    if (sw_val&(1<<1)){printf("Switch 1 :");}
    if (sw_val&(1<<2)){printf("Switch 2 :");}
    if (sw_val&(1<<3)){printf("Switch 3 :");}
    if (sw_val>0){printf("\r\n");}
    return sw_val;    
}

void SPI_TEST(void)
{
    read_switches();
    //LED Chaser display KIT lives on!
    for (uint32_t i=1;i<=128;i*=2)
    {
        spi_write_data(CS_GENERAL,i);             // Send data through spi
        wait_ms(20);
    }
    for (uint32_t i=128;i>=1;i/=2)
    {
        spi_write_data(CS_GENERAL,i);             // Send data through spi
        wait_ms(20);
    }
}