#include "SPI.h"

SPI spi(PA_7, PA_6, PA_5);      // Ordered as: mosi, miso, sclk could use forth parameter ssel
                                // However using multi SPI devices within FPGA with a seperate chip select
SPI spi_cmd(PA_7, PA_6, PA_5);  // NB another instance call spi_cmd for 8 bit SPI dataframe see later line 37
                                // For each device NB PA_7 PA_6 PA_5 are D11 D12 D13 respectively
                                
//DigitalOut LED_cs(PC_6);        // Chip Select for Basic Outputs to illuminate Onboard FPGA DEO nano LEDs CN7 pin 1
//DigitalOut LCD_cs(PB_15);       // Chip Select for the LCD via FPGA CN7 pin 3
//DigitalOut ADC_cs(PB_9);        // Chip Select for the ADC via FPGA CN7 pin 4

BusOut cs(PC_6,PB_15,PB_9);     // Chip Select => 111(7) = Nothing, 110(6) = General, 101(5) = LCD, 011(3) = ADC

//NBB the following line for F429ZI !!!!
DigitalIn DO_NOT_USE(PB_12);    // MAKE PB_12 (D19) an INPUT do NOT make an OUTPUT under any circumstances !!!!! ************* !!!!!!!!!!!
                                // This Pin is connected to the 5VDC from the FPGA card and an INPUT is 5V Tolerant


//Ticker ticktock;

void spi_write_data(short destination, unsigned int data)
{
    cs = destination;               // Select the device by seting chip select LOW
    spi_cmd.write(0);
    spi.write(data);
    cs = CS_RESET;                  // De-Select the device by seting chip select HIGH
}

int spi_read_data(short destination)
{
    cs = destination;               // Select the device by seting chip select LOW
    unsigned int read = spi.write(0);
    cs = CS_RESET;                  // De-Select the device by seting chip select HIGH
    return read;                    // Return the read switch value
}

int spi_read_write_data(short destination, unsigned int data)
{
    cs = destination;               // Select the device by seting chip select LOW
    spi_cmd.write(0);
    unsigned int read = spi.write(data);
    cs = CS_RESET;                  // De-Select the device by seting chip select HIGH
    return read;                    // Return the read switch value
}



void SPI_INIT (void)
{
    cs = CS_RESET;              // Chip must be deselected, Chip Select is active LOW
    
    spi.format(16,0);           // Setup the DATA frame SPI for 16 bit wide word, Clock Polarity 0 and Clock Phase 0 (0)
    spi_cmd.format(8,0);        // Setup the COMMAND SPI as 8 Bit wide word, Clock Polarity 0 and Clock Phase 0 (0)
    spi.frequency(1000000);     // 1MHz clock rate
    spi_cmd.frequency(1000000); // 1MHz clock rate
}
