#include "Button.hpp"

BYTE BUTTON::poll(void)
{
    switch(state)
    {
        case FALLEN :
            OUTPUT = 0;
            if(IN != 0){
                OUTPUT = 1;
                state = RISING;
                timer.reset();
                timer.start();
            }
        break;
        
        case RISING :
            OUTPUT = 0;
            if(timer.read_ms() > 100){
                timer.stop();
                state = RISEN;
            }
        break;
        
        case RISEN :
            OUTPUT = 0;
            if(IN != 0){
                OUTPUT = 2;
                state = FALLING;
                timer.reset();
                timer.start();
            }
        break;
        
        case FALLING :
            OUTPUT = 0;
            if(timer.read_ms() > 100){
                timer.stop();
                state = FALLEN;
            }
        break;
    }
    
    return OUTPUT;
}

BYTE BUTTON::rise(void)
{
    switch(state)
    {
        case FALLEN :
            OUTPUT = 0;
            if(IN != 0){
                OUTPUT = 1;
                state = RISING;
                timer.reset();
                timer.start();
            }
        break;
        
        case RISING :
            OUTPUT = 0;
            if(timer.read_ms() > 100){
                timer.stop();
                state = FALLEN;
            }
        break;
    }
    
    return OUTPUT;
}

/*BYTE BUTTON::fall(void)
{
    
    return OUTPUT;
}*/
