#include "mbed.h"
#include "sample_buffer.hpp"

//Thread sychronisation primatives
Semaphore spaceAvailable(BUFFERSIZE);
Semaphore samplesInBuffer(0);
Mutex bufferLock;

//Output buffer
char buffer[BUFFERSIZE];
unsigned int newestIndex = BUFFERSIZE-1;    //First time it is incremented, it will be 0
unsigned int oldestIndex = BUFFERSIZE-1;   

//Producer
void addCharacterToQueue(const char c)
{    
    //Is there space?
    int32_t Nspaces = spaceAvailable.wait();
             
    //Ok, there is space - take the lock
    bufferLock.lock();
        
    //Update buffer
    newestIndex = (newestIndex+1) % BUFFERSIZE;  
    buffer[newestIndex] = c;
    //printf("\tAdded ASCII Character: %2Xh (%c) to buffer, %d spaces available\n", c, c, Nspaces-1);
    
    //Release lock
    bufferLock.unlock();
    
    //Signal that a sample has been added
    samplesInBuffer.release();
}

//Consumer
char takeCharacterFromQueue()
{    
    //Are thre any samples in the buffer
    int32_t Nsamples = samplesInBuffer.wait();
        
    //Ok, there are samples - take the lock
    bufferLock.lock();   
    
    //Update buffer - remove oldest
    oldestIndex = (oldestIndex+1) % BUFFERSIZE;
    char cc = buffer[oldestIndex];
    //printf("\t\tTaking ASCII Character: %2Xh (%c) from buffer, %d bytes remaining\n", cc, cc, Nsamples-1);
    
    //Release lock
    bufferLock.unlock();
    
    //Signal there is space in the buffer
    spaceAvailable.release();
    
    //return a copy of the result
    return cc;
}

