/*******************************************************************************
This header defines Terminal class which has all the functions for controlling a 
terminal, the serial object is kept private and therefore can only be accessed
through function of the terminal class.
*******************************************************************************/

#include "mbed.h"
#include "rtos.h"
#include "General.hpp"

// Use generic to set number of rows in table
#define Rows 15
#define MaxDATA (Rows*4)

// Define 8 bit colours for printing to terminal 
#define ColourRED    9
#define ColourGREEN  118
#define ColourBLUE   12
#define ColourWhite  255
#define ColourPurple 5

// Class Terminal expects tx and rx pins and is used for controlling a serialy conected terminal
class Terminal {
    public:
        Terminal(PinName tx, PinName rx) : pc(tx, rx){}
        void init(void);
        void PrintDATA(BYTE* STRING, BYTE IDX);
        void PrintMSGS(BYTE* STRING);
        void DisplayCellIndex(void); // Prints index of cells into each cell for debug purpose
    private:
        Serial pc;
        void Cursor(BYTE X, BYTE Y); // Function moves cursor to position defined by co-ordinates x,y
        void Colour(BYTE COLOUR);    // Function changes terminal print colour to 8 bit colour defined by COLOUR
};

void TerminalThread(void); // Thread for terminal to run in

