#include "NetWorking.hpp"

// Thread handels networking and updates a conected PC whenever the webpage is refreshed
void NetWorkingThread(void)
{    
    // Configure an ethernet connection
    EthernetInterface eth;
    eth.set_network(IP, NETMASK, GATEWAY);
    eth.connect();
    
    // Now setup a web server
    TCPServer srv;           // TCP/IP Server
    TCPSocket clt_sock;      // Socket for communication
    SocketAddress clt_addr;  // Address of incoming connection
    
    // Open the server on ethernet stack
    srv.open(&eth);
    
    // Bind the HTTP port (TCP 80) to the server
    srv.bind(eth.get_ip_address(), 80);
    
    // Set maximum simultanious conections
    srv.listen(5);
    
    while (true) {
        using namespace std;
        
        // Block and wait on an incoming connection (if page is accessed)
        srv.accept(&clt_sock, &clt_addr);
        
        // Get most up to date enviromental values
        float LIGHT = 0.0f;
        float TEMP = 0.0f;
        float PRES = 0.0f;
        
        // Convert to a C String
        char Light_str[8];
        char Temp_str[8];
        char Pres_str[8];
        sprintf(Light_str, "%5.3f", LIGHT );
        sprintf(Temp_str, "%5.3f", TEMP );
        sprintf(Pres_str, "%5.3f", PRES );
        
        string response;

        // Build the C++ string response
        response = HTTP_MESSAGE_BODY1;
        response += Light_str;
        response += HTTP_MESSAGE_BODY2;
        response += Temp_str;
        response += HTTP_MESSAGE_BODY3;
        response += Pres_str;
        response += HTTP_CLOSE;
        
        // Send static HTML response (as a C string)
        int debug = clt_sock.send(response.c_str(), strlen(response.c_str())+6);   
    }
}

