#include "mbed.h"
#include "SDBlockDevice.h"
#include "FATFileSystem.h"
#include "General.hpp"
#include "rtos.h"

// Class SDReader expects mosi miso sclk and cs pins and is used for controlling a spi connected sd reader
class SDReader {
    public:
        SDReader(PinName mosi, PinName miso, PinName sclk, PinName cs) : sd(mosi, miso, sclk, cs), fs("sd", &sd){}
        BYTE INIT(void);
        void UPLOAD(FLOAT_32 LIGHT, FLOAT_32 TEMP, FLOAT_32 PRESS);
        BYTE* DOWNLOAD(void);
        void unmount(void);
    private:
        SDBlockDevice sd;
        FATFileSystem fs;
};

void SDThread(void); // Thread for terminal to run in

