#include "displayThread.h"
//InterruptIn button1(b1);
//InterruptIn button2(b2);

InterruptIn button1(b1);
InterruptIn button2(b2);

U_BYTE buttonPressed;

signed INT_32 increment[] = {10,1,10,1,1000,100,10,1,10,1,10,1,10,1};
signed INT_32 cursorPosition[] = {0,1,3,4,6,7,8,9,11,12,14,15};

dateTime d;
Pages page(RS,E,d4,d5,d6,d7); //rs,e,d4,d5,d6,d7
U_BYTE cursorPos=0;
enum pageNumber {PAGEONE, PAGETWO, PAGETHREE};

pageNumber currentPage;

EventQueue buttonQueue;

Timeout doublePress;

void DisplayThread()
{
  page.INIT();
	page.pageOne();
	page.pageOne();
	currentPage = PAGEONE;
	buttonPressed = 0;
	
	button1.rise(buttonISR1);
	button2.rise(buttonISR2);
	
	while(1)
	{
		buttonQueue.dispatch_forever();
	}
}

void pageSelect(U_BYTE buttonValue)
{
	switch (currentPage)
		{
			case PAGEONE:
				buttonActionOne(buttonValue);
				break;
			case PAGETWO:
				buttonActionTwo(buttonValue);
				break;
			case PAGETHREE:
				buttonActionThree(buttonValue);
				break;
		}
}

void buttonActionOne(U_BYTE buttonValue)
{
	switch(buttonValue)
	{
		case 0x01:
			page.pageTwo();
			currentPage = PAGETWO;
			page.setDateTime(d.getTime());
			cursorPos=0;
      break;
    //case 0x02:
    //  page.pageOne();
		//	currentPage = PAGEONE;
    //  break;   
    case 0x03:
      page.pageThree();
			currentPage = PAGETHREE;
      break;
   }
}
void buttonActionTwo(U_BYTE buttonValue)
{
	switch (buttonValue)
	{
		case 0x01:
			setValue(cursorPos,increment[cursorPos]);
			break;
		case 0x02:
			setValue(cursorPos,0-increment[cursorPos]);
			break;
		case 0x03:
			cursorPos++;
			break;
	}
	page.cursorPos(LINE1+cursorPosition[cursorPos]);
	if(cursorPos == 12)
	{
		page.pageOne();
		currentPage = PAGEONE;
	}
	
}

void buttonActionThree(U_BYTE buttonValue)
{
	switch(buttonValue)
	{
		case 0x01:
			page.pageOne();
			currentPage = PAGEONE;
      break;
	}
}
void setValue(BYTE cycle,signed INT_32 value)
{
    switch(cycle){
        case 0:
        case 1:
            d.addDay(value);
            page.setDateTime(d.getTime());
            
            break;
        
        case 2:
        case 3:
            d.addMonth(value);
            page.setDateTime(d.getTime());
            break;
            
        case 4:
        case 5:
        case 6:
        case 7:
            d.addYear(value);
            page.setDateTime(d.getTime());
            break;
            
        case 8:
        case 9:
            d.addHour(value);
            page.setDateTime(d.getTime());
            break;
        
        case 10:
        case 11:
            d.addMin(value);
            page.setDateTime(d.getTime());
            break;
        
        /*case 12:
        case 13:   
            d.addSec(value);
            page.setDateTime(d.getTime());
            break;*/
    }
}

void buttonISR1()
{
	buttonPressed |= 1;
	
	if(buttonPressed != 3){
		doublePress.attach(&buttonTO, 0.2);
	}
}

void buttonISR2()
{
	buttonPressed |= 2;
	
	if(buttonPressed != 3){
		doublePress.attach(&buttonTO, 0.2);
	}
}

void buttonTO()
{
	if(buttonPressed != 0){
		buttonQueue.call(&pageSelect,buttonPressed);
		buttonPressed = 0;
	}
}
