/*******************************************************************************
This cpp defines the functions for the terminal class which are used to 
control the terminal, it also defines the TerminalThread function which
is ran in its own thread and controls the printing of DATA to the Terminal
*******************************************************************************/
#include "Terminal.hpp"

// Thread for handiling the terminal
void TerminalThread(void)
{
    // Create Object PC of class Terminal with Set SERIAL_TX and SERIAL_RX pins
    Terminal PC(SERIAL_TX, SERIAL_RX);
    PC.init();
    PC.DisplayCellIndex();
    // Enter Forever loop
    while(1)
    {
        // If signal from SD thread recieved print message to terminal
        Thread::signal_wait(Signal_UnMount);
        PC.PrintMSGS("UNMOUNTED SD");
    }   
}

void Terminal::init(void)
{
    // Set baud rate for serial object pc
    pc.baud (115200);   
     
    // Hide cursor, move to x 0 y 0 and change print colour to green
    pc.printf("\x1b[?25l"); // Hides cursor
    //pc.printf("\x1b[3j"); // Clear screen
    Cursor(0,0);
    Colour(ColourGREEN);
 
    // Print DATA table to present data
    pc.printf("* ELEC351 : Low Power Enviromental Sensor *   Date and Time Here    *\n\r"
              "*********************************************************************\n\r"
              "*      TIME      *    TEMP (C)    * PRESSURE (mbar)*   LIGHT (LUX)  *\n\r"
              "*********************************************************************\n\r");
    for(BYTE idx = 0; idx < Rows; idx++)
    {
        pc.printf("*                *                *                *                *\n\r");
    }
    pc.printf("*********************************************************************\n\r"
              "* Debug *                                                           *");
    
    // Position cursor in first cell of table
    Cursor(3,3);
    Colour(ColourRED);
}

// Move cursor of pc terminal to co-ordinates 'X' and 'Y' (between 0 and 255)
void Terminal::Cursor(BYTE X, BYTE Y)
{
    pc.printf("\x1b[%d;%dH",Y,X);
}

// Change pc terminal print colour (8 bit colour) to colour defined by "COLOUR"
void Terminal::Colour(BYTE COLOUR)
{
    pc.printf("\x1b[38;5;%dm",COLOUR);
}

// Prints data(STRING) to cell in table defined by IDX
void Terminal::PrintDATA(BYTE* STRING, BYTE IDX)
{
    BYTE Y = (IDX/4)+5;
    BYTE X = ((IDX%4)*17)+3;
    Cursor(X,Y);
    pc.printf("%s",STRING);  
}

// Prints index of cells into each cell for debug purpose
void Terminal::DisplayCellIndex(void){
    for(BYTE IDX = 0; IDX < MaxDATA; IDX++){
        BYTE Y = (IDX/4)+5;
        BYTE X = ((IDX%4)*17)+3;
        Cursor(X,Y);
        pc.printf("%d",IDX);
    }        
}

// Prints MSGS (String) to debug line of terminal
void Terminal::PrintMSGS(BYTE* STRING)
{    
    Cursor((11),(Rows+6));
    pc.printf("%s",STRING);
}

