#include "SDReader.hpp"
#include "Button.hpp"

// Thread for saving DATA to the SD card
void SDThread(void)
{
    // Create object SD of the SDReader class with set SPI pins
    SDReader SD(PB_5, D12, D13, D10); // mosi, miso, sclk, cs   
    
    // Create switch to dismount the SD card
    BUTTON onBoardSwitch(USER_BUTTON);
    
    // Create variable to store state of SD card
    enum State {MOUNTED, UNMOUNTED, MOUNTING, UNMOUNTING};
    State Mounted = MOUNTING;
    
    while(1)
    {
        // FSM for each state of SD card
        switch(Mounted)
        {
            case UNMOUNTED :
                wait_ms(100);
                if(onBoardSwitch.poll() == 1)
                {
                    Mounted = MOUNTING;
                }
            break;
                
            case MOUNTED :
                //SD.UPLOAD(1.404f,0.303f,0.124f);
                wait_ms(100);
                if(onBoardSwitch.poll() == 1)
                {
                    Mounted = UNMOUNTING;
                }
            break;
                
            case UNMOUNTING :
                SD.unmount();
                Terminal_THREAD.signal_set(Signal_UnMount);
                Mounted = UNMOUNTED;
            break;
            
            case MOUNTING :
                if(SD.INIT() == 0){
                    Mounted = UNMOUNTED;
                    Terminal_THREAD.signal_set(Signal_UnMount);
                } else {
                    Mounted = MOUNTED;  
                }                
            break;
        }
    }
}

BYTE SDReader::INIT(void)
{
    BYTE Mount;
    
    // call the SDBlockDevice instance initialisation method.
    if(sd.init() != 0){
        Mount = 0;
    } else {
        Mount = 1;
    }
    
    if(Mount == 0){
        return Mount;
    } else {           
        //Remove existing file
        remove( "/sd/ELEC351.csv" );
        
        FILE* fp = fopen("/sd/ELEC351.csv","a+");
        //Check file handle (stream)
        if (fp == NULL) {
            return Mount;
        }
            
        //Put some text in the file...
        fprintf(fp, " TIME STAMP, light, temperature, pressure\n");
        
        //Close the file
        fclose(fp);
        
        return Mount;
    }
}

void SDReader::UPLOAD(FLOAT_32 LIGHT, FLOAT_32 TEMP, FLOAT_32 PRESS)
{   
    FILE* fp = fopen("/sd/ELEC351.csv","a+");
    //Check file handle (stream)
    if (fp == NULL) {
        return;
    }
    
    //Put some text in the file...
    fprintf(fp, " TIME STAMP, %1.4f, %1.4f, %1.4f\n", LIGHT, TEMP, PRESS);
    
    //Close the file
    fclose(fp);
}

BYTE* SDReader::DOWNLOAD(void)
{   
    FILE* fp = fopen("/sd/ELEC351.csv","r");
    if (fp == NULL) {

    }   
    
    //Read back all strings
    BYTE* s1 = new BYTE;
    
    //while (fscanf(fp, "%s", s1) == 1) 
    //{
    //
    //}
    
    fgets(s1, sizeof(s1), fp);
    
    //Close File
    fclose(fp);
    
    return s1;
}

void SDReader::unmount(void)
{
    sd.deinit();
    return;
}

