#include "mbed.h"
#include "DataTypes.hpp"
#include "Display.hpp"
#include "Terminal.hpp"
#include "displayThread.h"

//Thread tDisplay;

/*int main(void) {
    tDisplay.start(displayFunction);
    
    Terminal PC(SERIAL_TX, SERIAL_RX);
    PC.init();   
    PC.DisplayCellIndex();
    
    
    //S_BYTE temp = -5;
    while (true) {
        //led1 = !led1;
        //wait(0.5);
        Thread::wait(osWaitForever);
    }
}*/
InterruptIn button1(b1);
InterruptIn button2(b2);

volatile U_BYTE buttonPressed;

    #define b1 PE_12
    #define b2 PE_14
    
    #define RS  PD_15   //D9
    #define E   PF_12   //D8
    #define d4  PF_13   //D7
    #define d5  PE_9    //D6
    #define d6  PF_14   //D4
    #define d7  PF_15   //D2
    
    void buttonTrigger1();
    void buttonTrigger2();
    
DigitalOut green(PB_11);

Display display(RS,E,d4,d5,d6,d7); //rs,e,d4,d5,d6,d7

int main(void)
{
    buttonPressed = 0;
    button1.rise(&buttonTrigger1);
    button2.rise(&buttonTrigger2);
    wait_us(4000);
    display.INIT();
    wait_us(4000);
    display.pageOne();
    green = 0;
    while(1)
    {
        if(buttonPressed == 1)
        {
               display.pageTwo();
               buttonPressed &= 2; //clear bit 1
        }else if(buttonPressed == 2)
        {
                display.pageOne();
                buttonPressed &= 1;   
        }/*else if(buttonPressed == 3)
        {
               green = !green;
               buttonPressed = 0;
        }*/
    } //while(1);
}

void buttonTrigger1()
{
    buttonPressed |= 1; //set first bit
}

void buttonTrigger2()
{
    buttonPressed |= 2; //set second bit
}