#include "mbed.h"
#include "DataTypes.hpp"
#include "Terminal.hpp"

void Terminal::init(void)
{
    pc.baud (115200);   
     
    // Hide cursor, move to x 0 y 0 and change print colour to green
    pc.printf("\x1b[?25l");
    Cursor(0,0);
    Colour(ColourGREEN);
 
    // Print Table to be filled later
    pc.printf("*    TEMP     *  PRESSURE   *    LIGHT    *     OTR     *            *\n\r"
              "**********************************************************************\n\r");
    for(BYTE idx = 0; idx < Rows; idx++)
    {
        pc.printf("*             *             *             *             *            *\n\r");
    }
    pc.printf("**********************************************************************\n\r");
    
    // Position cursor in first cell of table
    Cursor(3,3);
    Colour(ColourRED);
}

// Move cursor of pc terminal to co-ordinates X and Y (between 0 and 255)
void Terminal::Cursor(BYTE X, BYTE Y)
{
    pc.printf("\x1b[%d;%dH",Y,X);
}

// Change pc terminal print colour (8 bit colour) to colour defined by COLOUR
void Terminal::Colour(BYTE COLOUR)
{
    pc.printf("\x1b[38;5;%dm",COLOUR);
}

// Prints data(STRING) to cell in table defined by IDX
void Terminal::PrintDATA(BYTE* STRING, BYTE IDX)
{
    BYTE Y = (IDX/3)+3;
    BYTE X = ((IDX%3)*14)+3;
    Cursor(X,Y);
    pc.printf("%s",STRING);  
}

// Prints index of cells into each cell for debug purpose
void Terminal::DisplayCellIndex(void){
    for(BYTE IDX = 0; IDX < MaxDATA; IDX++){
        BYTE Y = (IDX/3)+3;
        BYTE X = ((IDX%3)*14)+3;
        Cursor(X,Y);
        pc.printf("%d",IDX);
    }        
}
