#include "LCD.hpp"
#include "DataTypes.hpp"

//LCD data sheet: https://www.rapidonline.com/pdf/57-2224.pdf

void LCD::INIT()
{
    //All lines default low
    _LCD_RS = 0;
    _LCD_E  = 0;
    
    //LCD Initialise
    wait_ms(45); //Wait for LCD startup
    /*Step 1*/
        wait_us(40);      //Wait whilst LCD busy
        _LCD_RS = control;   
        LCD_DDRAM = 0;  //Clear data line
        LCD_DDRAM = (FUNC|bit8)>>4;  //Put data on line
        LCD_strobe();
    
    /*Step 2*/ cmdLCD(FUNC|lines2);  //Function Set 0x20|0x08 = 0x28
    /*Step 3*/ cmdLCD(FUNC|lines2);  //Function Set 0x20|0x08 = 0x28
    /*Step 4*/ cmdLCD(DISPLAY|on);    //Display Control 0x08|0x0x04 = 0x0c
    /*Step 5*/ cmdLCD(CLEAR);         //Clear Display 0x01
    /*Step 6*/ cmdLCD(ENTRYMODE|I);   //Set entry mode 0x04|0x02 = 0x06

    cmdLCD(RETURN); //return home location
}

void LCD::clear()
{
    cmdLCD(CLEAR);   
}

void LCD::display(BYTE* str, UINT_16 location)
{
    if(location != NULL)
    {
        pos(location);
    }
    U_BYTE p = 0;
    while((str[p]!= NULL)&&(p<16))
    {
        putt(str[p]);
        p++; 
    }
}

void LCD::pos(UINT_16 location)
{
    cmdLCD(0x80|location);   
}

void LCD::putt(U_BYTE c)
{
    wait_us(3000);
    _LCD_RS = text;
    set_LCD_data(c);
}

void LCD::cmdLCD(U_BYTE cmd)
{
    wait_us(3000);      //Wait whilst LCD busy
    _LCD_RS = control;   
    set_LCD_data(cmd);  //set data on bus
}

void LCD::LCD_strobe(void)
{
    wait_us(10);
    _LCD_E = 1;
    wait_us(10);
    _LCD_E = 0;
}

void LCD::set_LCD_data(U_BYTE d)
{
    // Send upper 4 bits then lower for bits
    // e.g. 11110000 => 1111 -> 0000
    
    LCD_DDRAM = 0;  //Clear data line
    LCD_DDRAM = d>>4;  //Put data on line
    LCD_strobe();
    wait_us(1000);
    LCD_DDRAM = 0;  //Clear
    LCD_DDRAM = d; //Put remaining data on line
    LCD_strobe();   
}

void LCD::enableCursor()
{
    cmdLCD(DISPLAY|on|cursor);
}

void LCD::disableCursor()
{
    cmdLCD(DISPLAY|on);
}