#ifndef _DISPLAY_HPP
#define _DISPLAY_HPP
    #include "mbed.h"
    #include "DataTypes.hpp"
    #include "LCD.hpp"
    
    class Display{
        public:
            Display(PinName rs, PinName e, PinName d4, PinName d5, PinName d6, PinName d7) : _lcd(rs,e,d4,d5,d6,d7) {} 
            void INIT();
            void clear();
            void pageOne();
            void pageTwo();
            
            void setTemperature(S_BYTE temp);
            void setLightLevel(U_BYTE light);
            void setPressure(U_BYTE pres);
        private:
            char _temperature[4];
            char _lightLevel[5];
            char _pressure[6];
        private:
            LCD _lcd;
    };
#endif