// Ultra Sonice Range Finder
// Experiement #1
// Belesiu
// 2014.12.26

#include "mbed.h"

DigitalOut myled(LED1);

I2C rangefinder(p9, p10);   // sda, sc1
Serial pc(USBTX, USBRX);    // tx, rx

const int addr = 0xE0;
char config_r[2];
char range_read[2];
float range;

#define N 8
float test_range[N] = {26.0, 100.0, 200.0, 300.0, 400.0,500.0, 600.0, 765.0};

AnalogOut signal(p18);

int main()
{
    int x = 0;
    int i = 0;

    while(1) {

        // Test serial port
        myled = 1;
        wait(0.2);
        myled = 0;
        wait(0.2);
        // pc.printf("Canned test program! - %d:  ", x++);

        range = test_range[i];

        pc.printf("%d Range = %.2f cm", x++, range); //print range on screen
        wait(0.05);
        
        // Output voltage proportional to distance.
        // The output value for the variable signal is 0 to 1.0.
        
        signal = range / 765.0;
        
        pc.printf(" Signal[%d] = %.2f \n\r", i, range / 765.0);
        wait(2.0);
        if(++i == N) i = 0;

    }
}
