#include "mbed.h"
#include "mbed_rpc.h"

Serial pc(USBTX, USBRX);

char buf[RPC_MAX_STRING], outbuf[RPC_MAX_STRING];
PwmOut led(LED3);

int main()
{
    led = 0.95;

// define classes
    RPC::add_rpc_class<RpcDigitalOut>();

// define outputs
    RpcDigitalOut rpc_rtng1(PTE5, "one");
    RpcDigitalOut rpc_rtng2(PTE3, "two");
    RpcDigitalOut rpc_En1(PTE4, "Enable1");
    RpcDigitalOut rpc_fan(PTB9, "three");
    RpcDigitalOut rpc_En2(PTB8, "Enable2");
    strcpy(buf, "/one/write 0");
    RPC::call(buf, outbuf);
    strcpy(buf, "/two/write 0");
    RPC::call(buf, outbuf);
    strcpy(buf, "/Enable1/write 0");
    RPC::call(buf, outbuf);
    strcpy(buf, "/three/write 0");
    RPC::call(buf, outbuf);
    strcpy(buf, "/Enable2/write 0");
    RPC::call(buf, outbuf);

// receive commands, and send back the responses
    while(1) {
        pc.gets(buf, 256);
        RPC::call(buf, outbuf);
        pc.printf("%s\n", outbuf);
    }
}
