#include "stm32f103c8t6.h"
#include "mbed.h"

// Interrupt example
// Changes the state of the led when pushed a button

DigitalOut led(PB_12);
InterruptIn button(PB_13);
Timer debounce;

void toggle_led();

int main()
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)    
    
    // calls the toggle_led function at the rising edge of the pin
    // when button is pressed the signal goes from low to high
    button.rise(&toggle_led);
    debounce.start();
    
  /*  while (1)
    {
    
    } */   
}

void toggle_led()
{
    if(debounce.read_ms() > 250)      // only allow toggle after 50 ms
    {
        led = !led;
        debounce.reset();          // restart timer after toggle    
    }         
}