#include "stm32f103c8t6.h"
#include "mbed.h"

// Timer and ticker example
// Shows how to use a timer and a ticker

DigitalOut led(PB_12);
Ticker toggler;
Timer timer;
Serial pc(PA_2, PA_3);

void toggle_led();

int main()
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)    
    pc.baud(9600);
    
    // toggle the led every 500 ms
    toggler.attach(&toggle_led, 0.5);
    
    timer.start();
    
    while (1)
    {
    
    }    
}

void toggle_led()
{
    // change the state of the led
    led = !led;
    
    // get the current time in ms
    int time = timer.read_ms();
    
    // print the time
    pc.printf("Time is: %d \r\n", time);
    
    // reset the timer
    timer.reset();
}