#include "stm32f103c8t6.h"
#include "mbed.h"

// Digital Out Example 
// Blinks the on-board LED at desired frequency

DigitalOut led(PB_12);
const int delay_time = 100;

int main()
{
    confSysClock();     //Configure system clock (72MHz HSE clock, 48MHz USB clock)    
    
    // led is off initially (one side of the led is connected to 3.3V)
    led = 1;

    while (1)
    {
        // led is off
        led = 1;
        
        // wait for specified amount of time
        wait_ms(delay_time);
        
        // led is on 
        led = 0;
        
        // wait for specified amount of time
        wait_ms(delay_time);
    }
}