/*
* PCF8575 Remote 16-bit I/O expander for I2C-bus
* Copyright (c) 2012 Bas van Drunen Littel
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/
#ifndef __PCF8575_H
#define __PCF8575_H

#define VERSION 1.0

#include <mbed.h>

#define PCF8575_I2C_ADDRESS     0x40

class PCF8575 {
public:
    PCF8575(I2C* _interface, unsigned char _chipselect);
    ~PCF8575(void);
    
    unsigned short ReadBytes(void);
    void WriteBytes(unsigned short bytes);
    void WriteBytes(unsigned char byte0, unsigned char byte1);
    
private:
    I2C* i2c; // Communication interface
    unsigned char address; //I2C address
};
#endif