/*
* PCF8575 Remote 16-bit I/O expander for I2C-bus
* Copyright (c) 2012 Bas van Drunen Littel
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in
* all copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN
* THE SOFTWARE.
*/

#include "pcf8575.h"

PCF8575::PCF8575(I2C* _interface, unsigned char _chipselect)
    : i2c(_interface)
{
    address = (_chipselect << 1) | PCF8575_I2C_ADDRESS;
}

PCF8575::~PCF8575() {}

unsigned short PCF8575::ReadBytes()
{
    char data[2];
    i2c->read(address,data,2);
    return (data[1]<<8) | data[0];
}

void PCF8575::WriteBytes(unsigned short bytes)
{
    char data[2];

    data[0] = bytes & 0xFF;
    data[1] = bytes>> 8;
    i2c->write(address,data,2);
}

void PCF8575::WriteBytes(unsigned char byte0, unsigned char byte1)
{
    char data[2];

    data[0] = byte0;
    data[1] = byte1;
    i2c->write(address,data,2);
}