#include "mbed.h"
#include "i2c.h"
#include "pca9685_reg.h"

DigitalOut myled(LED1);
Serial pc(USBTX, USBRX);
AnalogIn mypot(p20);

int main() {
   
    
    unsigned char level;
    unsigned char rgba_color[4];
    
    i2c_probe();
    init_pca9685(LEDDRV1);

    rgba_color[0]=0xff; //red (0-255)
    rgba_color[1]=0x00; //green (0-255)
    rgba_color[2]=0x00; //blue (0-255)
    rgba_color[3]=100; //amber (0-100) (0.00-1.00)
    
    while (1) {
        level=mypot*100;
        printf("level: %d\r\n",level);
        pca9685_rgba_led(LEDDRV1,RGBA_LED1,rgba_color,level);
        //channel_light(0,r*level/0xff);
        //channel_light(1,g*level/0xff);
        //channel_light(2,b*level/0xff);

    }
}

/* void loop() {
  int r, g, b;
 
  // fade from blue to violet
  for (r = 0; r < 256; r++) { 
    analogWrite(REDPIN, r);
    delay(FADESPEED);
  } 
  // fade from violet to red
  for (b = 255; b > 0; b--) { 
    analogWrite(BLUEPIN, b);
    delay(FADESPEED);
  } 
  // fade from red to yellow
  for (g = 0; g < 256; g++) { 
    analogWrite(GREENPIN, g);
    delay(FADESPEED);
  } 
  // fade from yellow to green
  for (r = 255; r > 0; r--) { 
    analogWrite(REDPIN, r);
    delay(FADESPEED);
  } 
  // fade from green to teal
  for (b = 0; b < 256; b++) { 
    analogWrite(BLUEPIN, b);
    delay(FADESPEED);
  } 
  // fade from teal to blue
  for (g = 255; g > 0; g--) { 
    analogWrite(GREENPIN, g);
    delay(FADESPEED);
  } 
}
--------------------------------------------------------------------------------
*/
