#ifndef __LED_CUBE_H
#define __LED_CUBE_H

#define VERSION 1.0

#include <mbed.h>
#include "pcf8574.h"
#include "pcf8575.h"

#define AXIS_X 1
#define AXIS_Y 2
#define AXIS_Z 3
#define PI 3.14159265
#define center 3.5
#define round(x)     ((x)>=0?(long)((x)+0.5):(long)((x)-0.5))

class LED_CUBE
{
public:
    LED_CUBE(I2C* _interface);
    ~LED_CUBE(void);

    void clear_cube(void);
    void setVoxel(unsigned char x, unsigned char y, unsigned char z);
    void clearVoxel(unsigned char x, unsigned char y, unsigned char z);
    unsigned char getVoxel(unsigned char x, unsigned char y, unsigned char z);
    void copyColumn(unsigned char x, unsigned char y, unsigned char col);
    void alterVoxel(unsigned char x, unsigned char y, unsigned char z, unsigned char state);
    void flipVoxel(unsigned char x, unsigned char y, unsigned char z);
    void setPlane_x (int x);
    void clearPlane_x (int x);
    void setPlane_y (int y);
    void clearPlane_y (int y);
    void setPlane_z (int z);
    void clearPlane_z (int z);
    void setPlane (char axis, unsigned char i);
    void clearPlane (char axis, unsigned char i);
    void setSlope_XY(int x1, int y1, int x2, int y2);
    void setSlope_XZ(int x1, int z1, int x2, int z2);
    void setSlope_YZ(int y1, int z1, int y2, int z2);
    void clearVoxels(void);
    void fill (unsigned char pattern);
    void box_filled(int x1, int y1, int z1, int x2, int y2, int z2);
    void box_walls(int x1, int y1, int z1, int x2, int y2, int z2);
    void box_wireframe(int x1, int y1, int z1, int x2, int y2, int z2);
    void line(int x1, int y1, int z1, int x2, int y2, int z2);
    void circle(int xr, int yr, int zr, int d ,char axis);
    void CopyBlock(int x1, int y1, int z1, int x2, int y2, int z2, int xc, int yc, int zc);
    void MoveBlock(int x1, int y1, int z1, int x2, int y2, int z2, int xm, int ym, int zm);
    void RotateBlock(int x1, int y1, int height, char axis, char dir);

private:
    PCF8574 row;
    PCF8575 colums_0_1;
    PCF8575 colums_2_3;
    PCF8575 colums_4_5;
    PCF8575 colums_6_7;
    unsigned char cubeData[64];
    Ticker duty;
    void UpdateRow(void);
    char byteline (int start, int end);
    unsigned char inrange(int x, int y, int z);
    void argorder(int ix1, int ix2, int *ox1, int *ox2);
    double map(double in, double inMin, double inMax, double outMin, double outMax);
    };
#endif