#include "Kalibratie.h"
#include "Filterdesigns.h"
//#include "MODSERIAL.h" //bugfix

//AnalogIn    emg2(A0); //Analog input van emg kabels niet meer nodig
//MODSERIAL   pc2(USBTX, USBRX); //bugfix
DigitalOut  LedGreen(LED2);
DigitalOut  LedRed(LED1);

int samples = 100;

void Init()
{
    LedGreen = 1;
    LedRed = 1;
}

double KalibratieMax(bool &readymax, AnalogIn emg)  //Kalibratie van de maximum waarde
{
    //pc2.baud(115200);
    LedGreen.write(0); //Led aan
    double ymax = 0;

    for(int i = 1; i <= samples; i++) { //Als timer onder de 5 seconden is dit uitvoeren
        double u = emg.read();
        double y = Filterdesigns(u);
        
        if (y > ymax && i >= samples / 10) { //Als de gemeten waarde groter is dan de opgeslagen waarde wordt dit de nieuwe opgeslagen waarde
            ymax = y;
        } 
        else {}
        //pc2.printf("y = %f en ymax = %f \n",y,ymax); //bugfix
        wait(0.05);
    }
    
    LedGreen.write(1); //Led aan
    readymax = 1; // Zodat systeem weet wanneer kalibratie voltooid is
    return ymax;
}

double KalibratieMin(bool &readymin, AnalogIn emg)  //Kalibratie van de minimum waarde
{
    //pc2.baud(115200);
    LedRed.write(0);
    double ymin = 10;

    for(int i = 1; i <= samples; i++) {
        double u = emg.read();
        double y = Filterdesigns(u);
        
        if (y < ymin && i >= samples / 10) {
            ymin = y;
        } 
        else {}
        //pc2.printf("y = %f en ymin = %f \n",y,ymin); //bugfix
        wait(0.05);
    }
    
    LedRed.write(1);
    readymin = 1;
    return ymin;
}