#include "mbed.h"
#include "HIDScope.h"
#include "Filterdesigns.h"
#include "Kalibratie.h"
#include "MODSERIAL.h" //bugfix
#include "Mode.h"

AnalogIn    emg(A0); //Analog input van emg kabels
HIDScope    scope(3); //3 scopes
Ticker      EMGticker;
MODSERIAL   pc(USBTX, USBRX); //bugfix
DigitalOut  LedBlue(LED3);
DigitalIn   button(PTA4);

//Sample frequentie
double Fs = 200; //Hz
double t = 1/ Fs; // voor EMGticker

bool readymax = 0;
bool readymin = 0;
double ymin;
double ymax;
double thresholdlow;
double thresholdmid;
double thresholdhigh;
bool go_flag = 0;

void EMGkalibratie()
{
    LedBlue = 1;
    Init();
    ymin = KalibratieMin(readymin, emg);
    wait(1);
    ymax = KalibratieMax(readymax, emg);

    // bepalen van thresholds voor aan/uit
    thresholdlow = 8 * ymin; // standaardwaarde
    thresholdmid = 0.5 * ymax; // afhankelijk van max output gebruiker
    thresholdhigh = 0.8 * ymax;

    pc.printf("ymax = %f en ymin = %f \n",ymax, ymin); //bugfix
}

void EMGfilter()
{
    //uitlezen emg signaal
    double u = emg.read();
    double y = Filterdesigns(u);
    //pc.printf("%f \n",y); //bugfix
    // Plotten in HIDscope
    int mode = Mode(y, ymax, thresholdlow, thresholdmid, thresholdhigh); //bepaald welk signaal de motor krijgt (aan, uit, middel)
    scope.set(0,u); //ongefilterde waarde naar scope 1
    scope.set(1,y); //gefilterde waarde naar scope 2
    scope.set(2,mode);
    scope.send(); //stuur de waardes naar HIDscope
}

void Go_flag(){
    go_flag = 1;
    }

int main()
{
    //pc.baud(115200);
    EMGticker.attach(&Go_flag, t); //500H
    while(1) {
        if(go_flag) {   // als deze true is dan gaat hij de onderstaande gebeuren aan
            go_flag = 0;
            if(button == 0) {
                readymax = 0;
                readymin = 0;
            } 
            else if(readymax == 0 || readymin == 0) {
                EMGkalibratie();
            } 
            else if(readymax == 1 && readymin == 1) {
                EMGfilter();
            }
        }
    }
}
