/*
Header file for Shooting mechanism.
 
Takes dutyCycle as a float and converts it t oduty cycle.
When off- dutyCycle is just switched to 0 duty cycle.

IMPORTANT: need to convert back to dutycycle=0, when not used!! 

Possible improvements:
-Convert program so when it's off the pins are completely off???  
-Caclutalate better time for the waits???
-maybe change the period??

TESTED AND WORKING - 06/03
IK
*/

#ifndef _SHOOTER_H
#define _SHOOTER_H

PwmOut squareOut(PTD0); //TESTED WORKING
DigitalOut solenoid(PTC16);

void shoot(float dutyCycle) {
    
    squareOut.period(0.01f);  // 0.01 second period
    squareOut.write(dutyCycle);  // 50% duty cycle
    wait(1.7); // give time for motors to reach optimal speed - is it needed 
    
    if (dutyCycle == 0.0) //if not used any more, don't shoot
        return;
    
    solenoid = 1; //push solenoid
    wait (0.3); // wait needed
    solenoid = 0;   //pull it back
     
    return;   
}

#endif