#include "SatelliteList.h"
#include <iostream>

SatelliteList::SatelliteList(char *f, char delimiter){

    string line;
    vector<string> v;    

    sfile.open(f);
    if (sfile.is_open()) { 
        while ( getline(sfile,line) ){
            if( line.empty() );          // ignore empty lines
            else if (line.at(0) != ';'){ // ignore comments
                split( v, line, ';' );
                //for ( int i = 0;  i < v.size();   i++) printf("%s ",v[i].c_str());
                //printf("\r\n");
                if (v.size() == 4) {
                    Satellite *s = new Satellite(v[0],v[1], ::atof(v[2].c_str()), ::atof(v[3].c_str()));
                    clist.addNode(*s);
                    delete s;
                }
                v.clear();
            }
        }
        //printf("Size Circular List = %d \r\n", clist.getSize());
        sfile.close();
    } else printf("Can't open filename %s\r\n", f);
}

void SatelliteList::split(vector<string> & theStringVector,  /* Altered/returned value */
       const  string  & theString,
       const  char  theDelimiter)
{
    

    size_t  start = 0, end = 0;

    while ( end != string::npos)
    {
        end = theString.find( theDelimiter, start);

        
        theStringVector.push_back( theString.substr( start,
                       (end == string::npos) ? string::npos : end - start));

        
        start = (   ( end > (string::npos - 1) )
                  ?  string::npos  :  end + 1);
    }
}

void SatelliteList::display()
{   
        string n, c ;
        float o,i ;
        
        clist.toHead();
        for ( int j = 0;  j < clist.getSize();   j++) {
            Satellite *s = clist.getNode();
            n = s->getName();
            c = s->getCname();
            o = s->getOrbit();
            i = s->getInclination();
            printf("Size = %d i = %d Name = %s Cname = %s \r\n",clist.getSize(), j, n.c_str(), c.c_str());
            clist.moveForward();
        }        
}

Satellite * SatelliteList::getNext()
{   
        clist.moveForward();
        Satellite *s = clist.getNode();
        return(s);   
}

Satellite * SatelliteList::getPrev()
{   
        clist.moveBackward();
        Satellite *s = clist.getNode();
        return(s);   
}

Satellite * SatelliteList::getCurrent()
{    if (!clist.isEmpty()) {
        Satellite *s = clist.getNode();
        return(s); 
     }  
}
