////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////BIBLIOTEK//////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#include "mbed.h"         //Standard bibliotek for mbed
#include "rtos.h"         //OS-5 embed bibliotek for og få benyttet thread - funksjonen.
#include <string>         //Bibliotek for og kunne benytte strenger.
#include <stdio.h>        //Bibliotek for og kunne logge til tekstfil i c++.


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////DEFINISJONER///////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


#define Inn 4                      //Hensikt: Hvis vi skriver "Inn" skriver vi egentlig tallet 4.
Serial pc(USBTX, USBRX);           //Hensikt: Lage en krets med datamaskinen igjennom USB porten, så vi kan utføre forskjellige ting igjennom f.eks tera-term.
LocalFileSystem local("local");    //Hensikt: Kunne skrive lokalt i en tekst fil i lagringssystemet til mbed.


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////INNGANGER//////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


DigitalIn Servicebryter(p20);  //Hensikt: Deklarere en bryter, som skal virke som en "innelåst bryter".
AnalogIn _Sone1(p15);          
AnalogIn _Sone2(p16);          //Hensikt: Deklarasjon av soner, som fungerer ved at det er 2 dører som er koblet i parallell med motstander,
AnalogIn _Sone3(p17);          //              og får dermed inn en voltverdi i inngangen som videre sier noe om hvilken tilstand dørene er i. (åpen / lukket)
AnalogIn _Sone4(p19);


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////UTGANGER///////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


DigitalOut Driftslys(LED1);            //Hensikt: Deklarere utgangen Driftslys som skal bli brukt som både alarm (10Hz blinking) og lyse konstant under normaldrift.
DigitalOut Utganger[8] = {p21, p22, p23, p24, p25,p26,p27,p28}; //Hensikt: Deklarere alle lys i en tabell, lysene skal lyse etter hvilket punkt det er alarm på.


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
/////////////////////////////////////////////////////////////////////////////////////////VARIABLER//////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


float Soner[Inn];                  //Hensikt: Deklarere en tabell som vi senere skal legge alle verdiene til de forskjellige sonene inn i.                  
int tilstand[8]= {};               //Hensikt: Sette inn de forskjellige tilstandene til dørene inn i en tabell.
int minne[8] = {};                 //Hensikt: Lagre tilstandene i en annen tabell etter en test, for og sjekke om det er en ny endring i tabellen.
volatile bool running = true;      //Hensikt: Sette funksjonen alarmf i else setning; dvs få lyset (LED1) til og lyse konstant.
volatile bool admin = false;       //Hensikt: Sjekker om vi har skrevet inn passord for og starte anlegget.
volatile bool start = false;       //Hensikt: Sjekker om vi har skrevet inn "Start" på tasturet, for og starte alarmanlegget.
volatile bool stopp = true;        //Hensikt: Sjekker om vi har skrevet inn "Stopp" på tasturet, for og stoppe alarmanlegget.
string passord = ("admin");        //Hensikt: Legge inn "admin" inn i en streng som er passordet til anlegget
string start_kommando = ("start"); //Hensikt: Legge inn "start" inn i en streng som er strengen for starte anlegget.
string stopp_kommando = ("stopp"); //Hensikt: Legge inn "stopp" inn i en streng som er strengen for og stoppe anlegget.
Timer t;                           //Hensikt: Deklarere en timer, som skal skal sjekke tiden som har gått etter oppstart.
int v = 0;                         //Hensikt: Printe til datamaskinen en gang, når man blir sendt inn i funksjonen password_check. ("Skriv Passord: ")


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
///////////////////////////////////////////////////////////////////////////////FUNKSJON DEKLARASJONER///////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
           
                                 
void Alarmf();                   // Hensikten til funksjonene er beskrevet nærmere ovenfor funksjonen, deklarasjoner skal bare vise compileren at funksjonene kommer
Thread Alarm;                    //      senere i programmet vårt.
Thread Read;
void admin_access_granted();
void sone_monitor();
int log_to_file(int, int);
void password_check();
void compare_commands();
void start_sys();
void stopp_sys();
int logg_start();
int logg_stopp();
int request_status_sys();
int request_status_alarm(int);
int TilstandSjekk();
extern "C" void mbed_reset();    //Hensikt: Kunne resete alarmsystemet 100% igjennom tastaturet. Dette er en standard funksjon i mbed.


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////////////////////MAIN//////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


//Hensikt: Starte funksjoner kontinuerlig i en while løkke utifra de globale variablene våre. Vi sjekker også om servicebryteren er aktivert, og vi vil da sette
//              programmet inn i "innelåst - modus" og resete alarmene. Man har da 10 sekunder på og komme seg ut, før alarmene reaktiverer seg.

int main()
{
    Read.start(password_check);
    t.start();
    while(1) {
        if(Servicebryter == 1) {  // "Innelåst - Modus"
            TilstandSjekk();
            running = false;
            pc.printf("NB! Alle alarmer er i innelast modus i 15 sek!! \n");
            wait(15);
        }
        while((admin) && (Servicebryter == 0)&&(start == true) && (stopp == false)) { // Sjekker globale variabler, for deretter og starte alarmsystemet.
            Alarm.start(Alarmf);//Denne funksjonen starter Alarmf i en tråd, dvs at denne går kontinuerlig og ikke stopper opp programmet.
            sone_monitor();
            wait(0.1);          //Vi benytter en wait funksjon for og få programmet til og fungere, hvis denne ikke er tilstede vil ikke programmet fungere korrekt.
            TilstandSjekk();
        }
    }
}


////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////
//////////////////////////////////////////////////////////////////////FUNKSJONER////////////////////////////////////////////////////////////////////////////////////
////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////////


//Hensikt: Få et lys til og lyse når alarmanlegget er i normaldrift.
//         Hvis alarmanlegget er i alarm-modus skal lyset blinke med en frekvens på 10 Hz.
//         Denne funksjonen blir kalt opp av en thread, som betyr at den kjører kontinuerlig seperat av andre funksjoner.

void Alarmf(void)
{
    while(1) {
        if(running == true) {  // Beskrivelse: Running er en global variabel som blir satt til false ved tilstand Normaldrift eller ved servicebryter lagt inn.
            Driftslys = !Driftslys;
            Thread::wait(20);  //Som vanlig wait funksjon, bare litt annen skrivemåte i thread biblioteket i OS5.
        } else {               // Hensikt: Hvis vi er i normaldrift driftlyset lyse kontinuerlig.
            Driftslys = 1;
        }
    }
}

//Hensikt: Legge måleresultater over motstandene inn i en tabell som videre setter korrekte tilstander inn i en annen tabell.

void sone_monitor()
{
    //Legger først de forskjellige sonene inn i en tabell.
    Soner[0] = _Sone1;
    Soner[1] = _Sone2;
    Soner[2] = _Sone3;
    Soner[3] = _Sone4;
    for(int i = 0, x = 0; i < 4; i++,x+=2) {              //Hensikt: Sjekker en og en sone.
        if( (Soner[i] > 0.35 ) && ( Soner[i] < 0.45) ) {  //Normaldrift: Begge dører lukket. utregnedt verdi: 0.4.
            tilstand[x] = 0;            
            tilstand[x+1] = 0;
        }
        if( (Soner[i] > 0.6 ) && ( Soner[i] < 0.7) ) {    //Tilstand1: Dør 1 åpen. Utregnet verdi: 0.65
            tilstand[x] = 1;
            tilstand[x+1] = 0;
            running = true;
        }
        if( (Soner[i] > 0.46 ) && ( Soner[i] < 0.55) ) {  //Tilstand2: Dør 2 åpen. Utregnet verdi: 0.5
            tilstand[x] = 0;
            tilstand[x+1] = 1;
            running = true;
        }
        if( (Soner[i] > 0.9) ) {                          //Tilstand 3: Begge dører er åpene. Utregnet verdi: 1. 
            tilstand[x] = 1;
            tilstand[x+1] = 1;
        }
    }
}

//Hensikt: Sette utgangsalarmlysene på ettersom tabellen tilstand[i] endrer seg. Sjekker om tilstandene er ulike som minne, hvis det er tilfelle setter vi de ulike
//               verdiene direkte til alarmutgangs tabellen. Etter dette starter vi log funksjonen for og logge endringen. Hvis den globale variabelen running
//               ikke er true nullstiller vi alarmutgangene. 

int TilstandSjekk() 
{
    if( running == true) {
        for (int i = 0; i < 8; i++) {
            if(minne[i] != tilstand[i]) {
                Utganger[i] = 1;    
                minne[i] = tilstand[i];
                log_to_file(i,Utganger[i]);
            }
        }
    } else {
        for (int i = 0; i < 8; i++) {
            Utganger[i] = 0;
        }
    }
    return 0;
}

////////////////////////////////////////////////////////////
/////////////////Mulige logg innforinger////////////////////
// Tid: t sekunder                                        //
// Alarm 1 har blitt utloost // Dette betyr Sone 1 door 1 //
// Alarm 2 har blitt utloost // Dette betyr Sone 1 door 2 //
// Alarm 3 har blitt utloost // Dette betyr Sone 2 door 1 //
// Alarm 4 har blitt utloost // Dette betyr Sone 2 door 2 //
// Alarm 5 har blitt utloost // Dette betyr Sone 3 door 1 //
// Alarm 6 har blitt utloost // Dette betyr Sone 3 door 2 //
// Alarm 7 har blitt utloost // Dette betyr Sone 4 door 1 //
// Alarm 8 har blitt utloost // Dette betyr Sone 4 door 2 //
////////////////////////////////////////////////////////////

//Hensikt: Skriver til en tekstfil når en alarm blir utløst. Samtidig som den skriver ned tiden siden anlegget startet.

int log_to_file(int c, int b)   // c er sone, b er tilsand.
{
    FILE *fp ;
    fp = fopen( "/local/log.txt", "a" ) ;
    if(fp != NULL) {
        float tid = t.read();
        fprintf(fp, "Tid: %.2f i sekunder siden systemet blir spenningsatt \nAlarm %d: er utloost \n", tid, c+1);
    }
    fclose(fp);
    return 0;
}

// Hensikt: Sette globale variabler, som har til hensikt å starte alarmanlegget. 
//          Minne tabellen som blir sammenlignet med utganger blir også nullstilt i denne funksjonen, for og vite
//                 om det har vært en alarm før funksjonen startet.
//          Itillegg skriver den ut en rekke forskjellige kommandoer som kan bli benyttet
//          til å kjøre forskjellige funksjoner i tera terma / annet program som skriver til pc. 

void admin_access_granted()
{
    admin = true;
    running = false;
    for (int i=0; i<8; i++) {  //Hensikt: Setter alle elementene i tabellen minne til 0, for og nullstille.
        minne[i] = 0;
    } 
    pc.printf("\nAdministrator tilgang innvilget\n");                                //Hensikt: Gi info
    pc.printf("Folgende kommandoer kan brukes: \n");                                 //Hensikt: Skrive ut en liste over alle funksjoner som er tilgjenglig.
    pc.printf("Starte overvaaking av systemet. Kommando: 'start' + 'Enter'\n");      //Hensikt: Starter alarmanlegget.
    pc.printf("Stoppe overvaaking av systemet. Kommando: 'stopp' + 'Enter'\n");      //Hensikt: Stopper alarmanlegget.
    pc.printf("Status alarm for hver sone. Kommando: 'staa1' + 'Enter' \n");                     //Hensikt: Sjekke om det er en alarm ved et spesifikk punkt.
    pc.printf("Status alle soner og dorer. Kommando: 'status' + 'Enter' \n");                  //Hensikt: Sjekke statusen til alle dører i alle sonere.
    pc.printf("Reset hele systemet. Kommando: 'reset' + 'Enter' \n");                          //Hensikt: Resete hele systemet.
    compare_commands();
}

//Hensikt: Passordbeskytter alarmsystemet ved hjelp av en string, funksjonen kjører i en thread, som vil si
//                at denne går kontinuerlig sammen med resten av programmet.
//         Når passord er riktig tastet inn, vil den alltid sørge for at compare_commands() kommandoen kjører.

void password_check()
{
    if(v == 0) {
        pc.printf("Skriv passord: ");
        v = 1;
    }
    if(admin == false) {
        char tastepassord[20];
        pc.scanf("%s",&tastepassord);
        int k = strcmp(tastepassord, "passord\0");
        if(!k) {
            admin_access_granted();
        }
    }
    while(admin == true) {
        compare_commands();
    }
}


//Hensikt: Sjekke inntastet verdi på tastatur oppimot våre funksjoner, for deretter og starte opp funksjoner som utfører 
//                riktige ting utifra inntastet verdi. Etter hver sjekk vil tabellen bli cleared.

void compare_commands()
{
    char read[20];
    pc.scanf("%s",&read);
    if(!strcmp(read, "start\0"))start_sys();
    if(!strcmp(read, "stopp\0")) stopp_sys();
    if(!strcmp(read, "reset\0")) mbed_reset();
    if(!strcmp(read, "reqa1\0")) request_status_alarm(1);
    if(!strcmp(read, "reqa2\0")) request_status_alarm(2);
    if(!strcmp(read, "reqa3\0")) request_status_alarm(3);
    if(!strcmp(read, "reqa4\0")) request_status_alarm(4);
    if(!strcmp(read, "reqa5\0")) request_status_alarm(5); 
    if(!strcmp(read, "reqa6\0")) request_status_alarm(6);
    if(!strcmp(read, "reqa7\0")) request_status_alarm(7);
    if(!strcmp(read, "reqa8\0")) request_status_alarm(8);
    if(!strcmp(read, "status\0")) request_status_sys();
    for (int i=0; i<19; i++) {
        read[i] = 0;
    }
}

//Hensikt: Starte alarmanlegget og kalle opp logg funksjonen for og logge start.

void start_sys() 
{
    start = true;
    stopp = false;
    pc.printf("Systemet ble startet\n");
    logg_start();
}

//Hensikt: Stopper alarmanlegget ved hjelp av globale variabler og kaller opp logg funksjonen for og logge stopp.

void stopp_sys()
{
    start = false;
    stopp = true;
    pc.printf("Systemet ble stoppet\n");
    logg_stopp();
}

//Hensikt: Skrive til en fil på pc, når alarmanlegget ble startet i tid fra spenningssetting.

int logg_start()
{
    FILE *fp ;
    fp = fopen( "/local/log.txt", "a" ) ;
    if(fp != NULL) {
        float tid = t.read();
        fprintf(fp, "Tid: %.2f i sekunder siden systemet blir spenningsatt \n Overvaakingen ble startet \n", tid);//t er tid

        fclose(fp);
        return 0;
    } else {
        return 1;
    }
}

//Hensikt: Skrive til en fil på pc, når alarmanlegget ble stoppet i tid fra spenningssetting.

int logg_stopp()
{
    FILE *fp ;
    fp = fopen( "/local/log.txt", "a" ) ;
    if(fp != NULL) {
        float tid = t.read();
        fprintf(fp, "Tid: %.2f i sekunder siden systemet blir spenningsatt \n Overvaakingen ble stoppet \n", tid);//t er tid
        fclose(fp);
        return 0;
    } else {
        return 1;
    }
}

//Hensikt: Skrive til status til alle dører til pc / tera term.

int request_status_alarm(int v)
{
    switch(v) {
        case 1:
            if(Utganger[v] == 1) {
                pc.printf("Door 1 i sone 1 er utloost\n");
            } else {
                pc.printf("Door 1 i sone 1 er ikke utloost\n");
            }
            break;
        case 2:
            if(Utganger[v] == 1) {
                pc.printf("Door 2 i sone 1 er utloost\n");
            } else {
                pc.printf("Door 2 i sone 1 er ikke utloost\n");
            }
            break;
        case 3:
            if(Utganger[v] == 1) {
                pc.printf("Door 1 i sone 2 er utloost\n");
            } else {
                pc.printf("Door 1 i sone 2 er ikke utloost\n");
            }
            break;
        case 4:
            if(Utganger[v] == 1) {
                pc.printf("Door 2 i sone 2 er utloost\n");
            } else {
                pc.printf("Door 2 i sone 2 er ikke utloost\n");
            }
            break;
        case 5:
            if(Utganger[v] == 1) {
                pc.printf("Door 1 i sone 3 er utloost\n");
            } else {
                pc.printf("Door 1 i sone 3 er ikke utloost\n");
            }
            break;
        case 6:
            if(Utganger[v] == 1) {
                pc.printf("Door 2 i sone 3 er utloost\n");
            } else {
                pc.printf("Door 2 i sone 3 er ikke utloost\n");
            }
            break;
        case 7:
            if(Utganger[v] == 1) {
                pc.printf("Door 1 i sone 4 er utloost\n");
            } else {
                pc.printf("Door 1 i sone 4 er ikke utloost\n");
            }
            break;
        case 8:
            if(Utganger[v] == 1) {
                pc.printf("Door 2 i sone 4 er utloost\n");
            } else {
                pc.printf("Door 2 i sone 4 er ikke utloost\n");
            }
            break;
    }
    return 0;
}

//Hensikt: Skrive status til alarmpunkt utifra inntastet valg på tastatur.

int request_status_sys()
{
    for(int u = 0; u <8; u++) {
        if(Utganger[u] == 1) {
            pc.printf("Alarm %d er utloost\n", u+1);
        } else {
            pc.printf("Alarm %d er ikke utloost\n", u+1);
        }
    }
    return 0;
}