// === LIBRAIRIES ===
#include "mbed.h" // Core library
#include "signature.h" // Signature des fonctions du main
#include "config_F303K8.h" // Configuration des paramètres de la carte
#include "SRF10.h"  // Télémètres Ultrasons SRF10
#include "AX12.h"  // Servomoteur numérique AX12
#include "DRV8825.h"  // Contrôleur de moteur pas à pas DRV8825
#include "Servo.h" // Servomoteur analogique

//Ici est présenté la totalité du programme mais dans le cadre du projet TPRobot 
//La plupart des fonctions présentées ci-dessous n'ont pas étaient crées par nos soins et nous ne les utilisons pas dans notre progamme

// === TIMER POUR REFERENCE HORAIRE ===
Timer timer; // Compte depuis le lancement de la carte le nombre de uSecondes

// === BUS DE COMMUNICATION ===
//Nous n'utilisons pas cette fonction
Serial rpi_serial(PORT_SERIAL_TX, PORT_SERIAL_RX); // Port série relié à la RPi
I2C i2c_telemetre(PORT_I2C_TELE_SDA, PORT_I2C_TELE_SCL); // Bus I2C des télémètres SRF10

// === TELEMETRES SRF10 ===
//Nous n'utilisons pas cette fonction
SRF10* tele[TELE_NUMBER]; // Tableau contenant les télémètres SRF10
int lastTimeTele, currentTele; // Temps du derner relevé télémétrique et télémètre qui a fait le relevé

// === SERVOS numériques AX12 ===
AX12* servoN[SERVO_N_NUMBER]; // Tableau contenant les servos AX12

// === SERVOS analogiques ===
Servo* servoA[SERVO_A_NUMBER]; // Tableau contenant les servos analogiques des fermoires

// === MOTEURS PAS A PAS ===
DRV8825 stepper(STEPPER_DIR, STEPPER_STEP, STEPPER_FAULT, STEPPER_MIN_PERIOD); // Moteur pas à pas de l'ascenseur

// === POMPE ===
DigitalOut pompe(POMPE_PIN); // Pin sur lequel est relié la pompe

// === PORT SERIE RPI ===
//Nous n'utilisons pas cette fonction
char indexBufferPortSerial; 
char bufferPortSerial[BUFFER_SERIAL_SIZE]; 

// === INDICATEURS / SIGNAUX ===
DigitalOut debugLed(LED1); // LED de debug
DigitalIn signalGo(SIGNAL_GO); // 0 => GO en attente / 1 => GO lancé
DigitalIn signalCouleur(SIGNAL_COULEUR); // 0 => VERT/ 1 => ORANGE

// === INITIALISATION DU ROBOT ===
void initRobot() {
    debugLed = 1;
    
    // Démarrage du timer
    timer.reset();
    timer.start();
    
    // Initialisation du port série
    indexBufferPortSerial = 0;
    rpi_serial.baud(PORT_SERIAL_BAUD);
    rpi_serial.attach(&processSerialPort);
    
    // Initialisation des télémètres
    lastTimeTele = 0; 
    currentTele = 0; 
    tele[0] = new SRF10(&i2c_telemetre, TELE1_ADDR, TELE1_RANG, TELE1_GAIN); // Télémètre droit
    tele[1] = new SRF10(&i2c_telemetre, TELE2_ADDR, TELE2_RANG, TELE2_GAIN); // Télémètre gauche
    tele[2] = new SRF10(&i2c_telemetre, TELE3_ADDR, TELE3_RANG, TELE3_GAIN); // Télémètre arrière
    tele[3] = new SRF10(&i2c_telemetre, TELE4_ADDR, TELE4_RANG, TELE4_GAIN); // Télémètre avant
    
    // Initialisation des servos AX12
    servoN[0] = new AX12(SERVO_N_SERIAL_TX, SERVO_N_SERIAL_RX, SERVO1_N_ADDR); // Bras centre
    servoN[1] = new AX12(SERVO_N_SERIAL_TX, SERVO_N_SERIAL_RX, SERVO2_N_ADDR); // Bras extremité
    
    // Initialistion des servos analogiques
    servoA[0] = new Servo(SERVO1_A_PIN, SERVO1_A_RANGE, SERVO1_A_OPEN, SERVO1_A_CLOSE); // Droit grand
    servoA[1] = new Servo(SERVO2_A_PIN, SERVO2_A_RANGE, SERVO2_A_OPEN, SERVO2_A_CLOSE); // Droit petit
    servoA[2] = new Servo(SERVO3_A_PIN, SERVO3_A_RANGE, SERVO3_A_OPEN, SERVO3_A_CLOSE); // Gauche grand
    servoA[3] = new Servo(SERVO4_A_PIN, SERVO4_A_RANGE, SERVO4_A_OPEN, SERVO4_A_CLOSE); // Gauche petit
    
    // Initialisation du moteur à pas
    stepper.reset(STEPPER_RESET, 1);

    // Initialisation de la pompe
    pompe = 0;
    
    // Initialisation des signaux
    signalGo.mode(PullUp);
    signalCouleur.mode(PullUp);
    
    // Séquence de mise à zéro
    sequenceInitialisationIA();

    // Initialisation OK
    wait(1);
    debugLed = 0;
    
    // Attente du lancement de la boucle principale
    while (!signalGo) {
        wait(0.01);
    }
    
}



// === INTERPRETATION MESSAGE PORT SERIE ===
//Nous n'utilisons pas cette fonction
void interpreterRequete() {
    char ordre;
    int param1 = 0;
    int param2 = 0;
    int param3 = 0;
    int param4 = 0;
    sscanf(bufferPortSerial ,"%c %d %d %d %d", &ordre, &param1, &param2, &param3, &param4);
    switch (ordre) {
        case 'I': // IDENTIFICATION | On renvoie le nom de la carte
            rpi_serial.printf("CarteControle");
            break;
        case 'S': // START | On renvoie 1 quand le GO est lancé, 0 sinon
            rpi_serial.printf("%d\n", signalGo.read());
            break;
        case 'C': // COULEUR | On renvoie 0 si VERT, 1 si ORANGE
            if (signalCouleur.read() == 0) {
                rpi_serial.printf("color 0\n");
            } else {
                rpi_serial.printf("color 1\n");
            }
            break;
        case 'B': // BRAS | Permet de controler les servos AX12 | B <id> <angle> <speed>
            servoN[param1]->setSpeedMove(param2, param3);
            rpi_serial.printf("1\n");
            break;
        case 'F': // FERMOIRES | Permet de controler les servos analogiques  | F <id> <etat>
            if (param2 == 0) {
                servoA[param1]->close();
            } else {
                servoA[param1]->open();
            }
            rpi_serial.printf("1\n");
            break;
        case 'P': // POMPE | Permet d'activer ou desactiver la pompe | P <etat>
            pompe = param1;
            rpi_serial.printf("1\n");
            break;
        case 'A': // ASCENSEUR | Permet de controler l'ascenseur | A <pas> <direction> <estBloquant> <temps>
            stepper.setGoal(param1, param2, param4);
            if (param3 == 1) {
                stepperBloquant();
            }
            rpi_serial.printf("1\n");
            break;
        case 'T': // TELEMETRES | Permet de renvoyer les infos de distance des télémètres | <droite> <gauche> <arriere> <avant>
            rpi_serial.printf("%d %d %d %d\n", tele[0]->getRange(), tele[1]->getRange(), tele[2]->getRange(), tele[3]->getRange());
            break;            
    }
}



// === MESSAGE RECU SUR LE PORT SERIE ===
//Nous n'utilisons pas cette fonction
void processSerialPort() {
    while (rpi_serial.readable()) {
        bufferPortSerial[indexBufferPortSerial] = rpi_serial.getc();
        if (bufferPortSerial[indexBufferPortSerial] == '\n') {
            interpreterRequete();
            indexBufferPortSerial = 0;
            for (int index = 0; index <= indexBufferPortSerial; index++) {
                bufferPortSerial[index] = 0;
            }
        } else {
            indexBufferPortSerial++;
        }
    }
}

// === MISE A JOUR DES TELEMETRES === 
//Nous n'utilisons pas cette fonction
void updateTelemetreMeasure() {
    if ((timer.read_ms()-lastTimeTele) >= TELE_PERIOD/TELE_NUMBER) {
        tele[currentTele]->updateRange();
        if (++currentTele == TELE_NUMBER) {
            currentTele = 0;
        }
        lastTimeTele = timer.read_ms();
    }
}

// === PERMET DE METTRE A JOUR LE STEPPER EN BLOQUANT ===
void stepperBloquant() {
    while(!stepper.isMoveComplete()) {
        stepper.update(timer.read_ms());
    }
}

// === ETAT DU ROBOT LORS DU DEMARRAGE DE L'IA === 
//Nous n'utilisons pas cette fonction
void sequenceInitialisationIA() {
    stepper.setGoal(1000, 0, 0);
    servoN[0]->setSpeedMove(SERVO1_N_INIT, 100);
    servoN[1]->setSpeedMove(SERVO2_N_INIT, 150);
    stepperBloquant();
    servoA[0]->close();
    servoA[1]->open();
    servoA[2]->close();
    servoA[3]->open();
}



// === MAIN ===
int main() {
 
    // Mettre les différentes instructons ici. Ce qu'il est possible :
    // stepper.setGoal(<bombre de pas>, <direction>, <temps>). -> Commande le pas à pas de l'ascenseur
    // stepperBloquant() -> A mettre toujours après un stepper.setGoal. Permet de faire tout le mouvement
    // servoN[<id>]->setSpeedMove(<angle>, <temps>) -> Commande un des servos du bras. Plus le temps est petit plus le servo est lent
    // servoA[<id>]->close() OU servoA[<id>]->open() -> Commande un des servos analogiques des fermoires pour soit les ouvrir soit les fermer
    // pompe=1 OU pompe=1 -> Pour activer ou désactiver la pompe
    // wait(<secondes>) -> attendre x secondes. Possible de mettre des chiffres à virgules
    initRobot();
    servoA[0]->open();
    servoA[2]->open();
    wait(1);
    
    //Premier cube
    
    servoN[0]->setSpeedMove(147,500);
    servoN[1]->setSpeedMove(198,500);
    wait(1);
    pompe=1;
    stepper.setGoal(1000, 1, 0);
    stepperBloquant();
    stepper.setGoal(400, 0, 0);
    stepperBloquant();
    servoN[1]->setSpeedMove(255,300);
    wait(1);
    servoN[0]->setSpeedMove(170,300);
    wait(1);
    
    pompe=0;
    wait(2);
    servoN[0]->setSpeedMove(150,500);
    servoN[1]->setSpeedMove(150,500);
    wait(1);
    servoA[0]->close();
    servoA[1]->close();
    servoA[2]->close();
    servoA[3]->close();
    wait(1);
    servoA[0]->open();
    servoA[1]->open();
    servoA[2]->open();
    servoA[3]->open();
    
    //Second cube
        
    servoN[0]->setSpeedMove(153,500);
    servoN[1]->setSpeedMove(102,500);
    wait(1);
    pompe=1;
    stepper.setGoal(1000, 1, 0);
    stepperBloquant();
    stepper.setGoal(2500, 0, 0);
    stepperBloquant();
    servoN[1]->setSpeedMove(250,300);
    wait(1);
    servoN[0]->setSpeedMove(165,300);
    wait(1);
    
    pompe=0;
    wait(2);
    servoN[0]->setSpeedMove(150,500);
    servoN[1]->setSpeedMove(150,500);
    wait(1);
    servoA[0]->close();
    servoA[1]->close();
    servoA[2]->close();
    servoA[3]->close();
    wait(1);
    servoA[0]->open();
    servoA[1]->open();
    servoA[2]->open();
    servoA[3]->open();
    
    //Troisième cube
    
    servoN[0]->setSpeedMove(180,500);
    servoN[1]->setSpeedMove(90,500);
    wait(1);
    pompe=1;
    stepper.setGoal(2500, 1, 0);
    stepperBloquant();
    stepper.setGoal(600, 0, 0);
    stepperBloquant();
    servoN[1]->setSpeedMove(50,300);
    wait(1);
    servoN[0]->setSpeedMove(127,300);
    wait(1);
    
    pompe=0;
    wait(2);
    servoN[0]->setSpeedMove(150,500);
    servoN[1]->setSpeedMove(150,500);
    wait(1);
    servoA[0]->close();
    servoA[1]->close();
    servoA[2]->close();
    servoA[3]->close();
    wait(1);
    servoA[0]->open();
    servoA[1]->open();
    servoA[2]->open();
    servoA[3]->open();
}