#ifndef ROBOT_CONFIG
#define ROBOT_CONFIG

//==========================================
// PORT SERIAL RPI
#define PORT_SERIAL_TX USBTX
#define PORT_SERIAL_RX USBRX
#define PORT_SERIAL_BAUD 115200
#define BUFFER_SERIAL_SIZE 100

//==========================================
// PORT I2C TELEMETRES
#define PORT_I2C_TELE_SDA PB_7
#define PORT_I2C_TELE_SCL PB_6

// TELEMETRE US GENERAL
#define TELE_PERIOD 65
#define TELE_NUMBER 4

// TELEMETRE SRF10 no.1 => DROIT
#define TELE1_ADDR 0xE0
#define TELE1_RANG 0x0F
#define TELE1_GAIN 0x10

// TELEMETRE SRF10 no.2 => GAUCHE
#define TELE2_ADDR 0xE2
#define TELE2_RANG 0x0F
#define TELE2_GAIN 0x10

// TELEMETRE SRF10 no.3 => ARRIERE
#define TELE3_ADDR 0xE4
#define TELE3_RANG 0x35
#define TELE3_GAIN 0x10

// TELEMETRE SRF10 no.4 => AVANT
#define TELE4_ADDR 0xE6
#define TELE4_RANG 0x35
#define TELE4_GAIN 0x10

//==========================================
// SERVOS AX12 GENERAL
#define SERVO_N_SERIAL_TX PA_9
#define SERVO_N_SERIAL_RX PA_10
#define SERVO_N_NUMBER 2

// SERVO AX12 no.1 => Bras central
#define SERVO1_N_ADDR 2
#define SERVO1_N_INIT 120

// SERVO AX12 no.2 => Bras extension
#define SERVO2_N_ADDR 1
#define SERVO2_N_INIT 275

//==========================================
// SERVOS ANALOGIQUES GENERAL
#define SERVO_A_NUMBER 4

// SERVO FUTABA => Cube Droite Grand
#define SERVO1_A_PIN PB_4
#define SERVO1_A_RANGE 0.0009
#define SERVO1_A_OPEN 0.25
#define SERVO1_A_CLOSE 0.75

// SERVO SG-90 => Cube Droite Petit
#define SERVO2_A_PIN PB_5
#define SERVO2_A_RANGE 0.0007
#define SERVO2_A_OPEN 0
#define SERVO2_A_CLOSE 1

// SERVO FUTUBA => Cube Gauche Grand
#define SERVO3_A_PIN PA_11
#define SERVO3_A_RANGE 0.0009
#define SERVO3_A_OPEN 0.8
#define SERVO3_A_CLOSE 0.3

// SERVO MG-90 => Cube Gauche Petit
#define SERVO4_A_PIN PA_8
#define SERVO4_A_RANGE 0.0009
#define SERVO4_A_OPEN 0
#define SERVO4_A_CLOSE 0.91

//==========================================
// MOTEUR PAS A PAS DRV8825
#define STEPPER_DIR PA_6
#define STEPPER_STEP PA_7
#define STEPPER_FAULT PA_5
#define STEPPER_RESET PB_0
#define STEPPER_MIN_PERIOD 1

//==========================================
// POMPE
#define POMPE_PIN PA_4

//==========================================
// SIGNAUX DIVERS
#define SIGNAL_GO PA_12
#define SIGNAL_COULEUR PA_0

#endif