#include "mbed.h"

PwmOut phaseA(PA_8);    //Out1, Green
DigitalOut phaseAEN(PC_10);
PwmOut phaseB(PA_9);    //Out2, Blue
DigitalOut phaseBEN(PC_11);
PwmOut phaseC(PA_10);   //Out3, White
DigitalOut phaseCEN(PC_12);

AnalogIn pot(PB_1);

InterruptIn button(USER_BUTTON);

DigitalOut redLed(PB_2);
DigitalOut led(LED1);
InterruptIn hallA(PA_15);   //H1, Green
InterruptIn hallB(PB_3);    //H2, Blue
InterruptIn hallC(PB_10);   //H3, White

//InterruptIn hallA(PB_3);   //New: H2; Original: H1, Green
//InterruptIn hallB(PB_10);  //New: H3; Original: H2, Blue
//InterruptIn hallC(PA_15);  //New: H1; Original: H3, White

Ticker rpmInterrupt;
int revCount = 0;
int rpmPrintFlag = 0;
int currentRPM;

float pwmMax = 0.9;
float pwmDuty;
int stall = 0;
int reverse = 0;

void rpmCalc()
{
    currentRPM = revCount * 60; //account for elec vs mech rpm
    revCount = 0;
    rpmPrintFlag = 1;
}
//to switch to old motor config, change letter of interrupts. old:ABC, new:BCA
void Arise()    //state1, A0 B- C+
{   
    phaseAEN = 0;
    phaseBEN = 1;
    
    phaseC.write(pwmDuty);
    phaseCEN = 1;
//    redLed = ! redLed;
    revCount++;
}

void Cfall()    //state2, A+ B- C0
{
    phaseCEN = 0;
    phaseC.write(0);
    phaseA.write(pwmDuty);
    phaseAEN = 1;
    
    phaseBEN = 1;
}

void Brise()    //state3, A+ B0 C-
{
    phaseBEN = 0;
    phaseCEN = 1;
    
    phaseA.write(pwmDuty);
    phaseAEN = 1;
}

void Afall()    //state4, A0 B+ C-
{
    phaseAEN = 0;
    phaseA.write(0);
    phaseB.write(pwmDuty);
    phaseBEN = 1;
    
    phaseCEN = 1;
//    redLed = ! redLed;
}

void Crise()    //state5, A- B+ C0
{
    phaseCEN = 0;
    phaseAEN = 1;
    
    phaseB.write(pwmDuty);
    phaseBEN = 1;
}

void Bfall()    //state6, A- B0 C+
{
    phaseBEN = 0;
    phaseB.write(0);
    phaseC.write(pwmDuty);
    phaseCEN = 1;
    
    phaseAEN = 1;
}


void jumpStart()
{
    int h1 = hallA.read();
    int h2 = hallB.read();
    int h3 = hallC.read();
    //check where we start
    if(h1 == 0 && h2 == 1 && h3 == 1)   //state1
    {
        Crise();
        Bfall();
    }
    else if(h1 == 0 && h2 == 0 && h3 == 1)  //state2
    {
        Bfall();
        Arise();
    }
    else if(h1 == 1 && h2 == 0 && h3 == 1)  //state3
    {
        Arise();
        Cfall();
    }
    else if(h1 == 1 && h2 == 0 && h3 == 0)     //state4
    {
        Cfall();
        Brise();
    }
    else if(h1 == 1 && h2 == 1 && h3 == 0)  //state5
    {
        Brise();
        Afall();
    }
    else    //state6
    {
        Afall();
        Crise();
    } 
}

void activate()
{
    if(stall == 0)
    {
        stall = 1;
    }
    else
    {
        jumpStart();
//        if(reverse == 1)    //switch to forward
//        {
//            hallA.fall(&Afall);
//            hallA.rise(&Arise);
//            hallB.fall(&Bfall);
//            hallB.rise(&Brise);
//            hallC.fall(&Cfall);
//            hallC.rise(&Crise);
//            redLed = !redLed;
//            reverse = 0;
//        }
//        else if(reverse == 0)    //switch to reverse
//        {
//            hallA.fall(&Bfall);
//            hallA.rise(&Brise); 
//            hallB.fall(&Cfall);
//            hallB.rise(&Crise);
//            hallC.fall(&Afall);
//            hallC.rise(&Arise);
//            redLed = !redLed;
//            reverse = 1;
//        }
    }
}

int main() {     
    //wait until button push to start
    rpmInterrupt.attach(&rpmCalc, 1);
    button.rise(&activate);
    while(stall == 0) {
        led = !led;
        wait(1);
    }

    pwmDuty = pot.read() * pwmMax;

    phaseA.period_us(50);
    phaseB.period_us(50);
    phaseC.period_us(50);
    
    phaseA.write(0);
    phaseB.write(0);
    phaseC.write(0);    
    
    phaseAEN = 0;
    phaseBEN = 0;
    phaseCEN = 0;
    //begin sensored mode 
    hallA.fall(&Afall);
    hallA.rise(&Arise);
    hallB.fall(&Bfall);
    hallB.rise(&Brise);
    hallC.fall(&Cfall);
    hallC.rise(&Crise); 
    
    jumpStart();
    float ADCSum = 0;;
    int ADCCount = 0;
    while(1) {
        led = !led;
        ADCSum += pot.read();
        ADCCount++;
        if(ADCCount == 20)
        {
            pwmDuty = (ADCSum/20) * pwmMax;
            ADCSum = 0;
            ADCCount = 0;
        }
        if(rpmPrintFlag == 1)
        {
            printf("%d rpm; %f duty\r\n", currentRPM, pwmDuty);
            rpmPrintFlag = 0;
        }
        wait(0.05);
    }
}
