#include "mbed.h"

PwmOut phaseA(PA_8);
DigitalOut phaseAEN(PC_10);
PwmOut phaseB(PA_9);
DigitalOut phaseBEN(PC_11);
PwmOut phaseC(PA_10);
DigitalOut phaseCEN(PC_12);

InterruptIn button(USER_BUTTON);

DigitalOut led(LED1);
Ticker interrupt;

int count = 0;
float pwmDuty = 0.3;

void intcall(){
    count = (count + 1) % 6;
    
    if(count == 0)  //B+, C-
    {
//        phaseA = 0;
//        phaseAP = 0;
//        phaseB = 1;
//        phaseBP = 0;
//        phaseC = 0;
//        phaseCP = 1;
        phaseAEN = 0;
        phaseA.write(0);
        phaseB.write(pwmDuty);
        phaseBEN = 1;
    }
    else if(count == 1) //B+, A-
    {
//        phaseA = 0;
//        phaseAP = 1;
//        phaseB = 1;
//        phaseBP = 0;
//        phaseC = 0;
//        phaseCP = 0;
        phaseCEN = 0;
        phaseAEN = 1;
    }
    else if(count == 2) //C+, A-
    {
//        phaseA = 0;
//        phaseAP = 1;
//        phaseB = 0;
//        phaseBP = 0;
//        phaseC = 1;
//        phaseCP = 0;
        phaseBEN = 0;
        phaseB.write(0);
        phaseC.write(pwmDuty);
        phaseCEN = 1;
    }
    else if(count == 3) //C+, B-
    {
//        phaseA = 0;
//        phaseAP = 0;
//        phaseB = 0;
//        phaseBP = 1;
//        phaseC = 1;
//        phaseCP = 0;
        phaseAEN = 0;
        phaseBEN = 1;
    }
    else if(count == 4) //A+, B-
    {
//        phaseA = 1;
//        phaseAP = 0;
//        phaseB = 0;
//        phaseBP = 1;
//        phaseC = 0;
//        phaseCP = 0;
        phaseCEN = 0;
        phaseC.write(0);
        phaseA.write(pwmDuty);
        phaseAEN = 1;
    }
    else if(count == 5) //A+, C-
    {
//        phaseA = 1;
//        phaseAP = 0;
//        phaseB = 0;
//        phaseBP = 0;
//        phaseC = 0;
//        phaseCP = 1;
        phaseBEN = 0;
        phaseCEN = 1;
    }
}

int stall = 0;
void activate()
{
    stall = 1;
}

int main() {
    float intDelay = .05;
//    float minDelay = .005;
    float minDelay = .015;
    button.rise(&activate);
    while(stall == 0) {
        led = !led;
        wait(2);
    }
    interrupt.attach(&intcall, intDelay);
    phaseA.period_us(10);
    phaseB.period_us(10);
    phaseC.period_us(10);
    
    phaseA.write(0);
    phaseB.write(pwmDuty);
    phaseC.write(0);    
    
    phaseAEN = 0;
    phaseBEN = 1;
    phaseCEN = 1;
    
    while(1) {
        led = !led;
        wait(0.2);
        if(intDelay > minDelay)
        {
            intDelay -= .001;
            interrupt.detach();
            interrupt.attach(&intcall, intDelay);
//            pwmDuty += .01;
            pwmDuty += .007;
        }
    }
}
