#include "mbed.h"

#define COMMAND 0
#define DATA 1

Serial pc(USBTX, USBRX);
Serial birefSensor(p9,p10);
DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
AnalogOut birefOut(p18);
BusInOut databus(p21, p22, p23, p24, p25, p26, p27, p28);
DigitalOut registerSelect(p30);
DigitalOut readWriteClock(p29);
Ticker updateLCD;


char rcvBuff[80];
int buffIdx = 0;
float birefVal, birefStdDev;

void writeToLCD(bool rs, char data){

    // set register select pin 
    registerSelect = rs;
    
    // set read/write pin to write
    //readWrite = 0;
    
    // set bus as output
    databus.output();
    
    // put data onto bus
    databus = data;
    
    // pulse read/write clock
    readWriteClock = 1;
    
    wait_us(1);
    
    readWriteClock = 0;

    wait_us(1);
    
    // clear data bus
    databus = 0;
    
    //pc.printf("%02x\n", data);
    
}


char readFromLCD(bool rs){

    char data;
    
    // set register select pin 
    registerSelect = rs;
    
    // set read/write pin to read
    //readWrite = 1;
    
    // set bus as output
    databus.input();
    
    // put data onto bus
    data = databus;
    
    // pulse read/write clock
    readWriteClock = 1;
    
    wait_us(10);
    
    readWriteClock = 0;
    
    return data;
}


void resetLCD(){
}


void initLCD(){
    
    // wait 15 ms to allow LCD to initialise
    wait_ms(15);
    
    // set interface for 8 bit mode
    writeToLCD(COMMAND, 0x30);

    // give it time    
    wait_ms(5);

    // set interface for 8 bit mode again
    writeToLCD(COMMAND, 0x30);

    // give it time    
    wait_us(100);

    // set interface for 8 bit mode again, last one before we can configure the display
    writeToLCD(COMMAND, 0x30);

    // give it time    
    wait_us(500);
    
    // set interface for 8 bit mode, 2 display lines and 5 x 8 character font
    writeToLCD(COMMAND, 0x38);

    // give it time    
    wait_us(100);
    
    // display off
    writeToLCD(COMMAND, 0x08);

    // give it time    
    wait_us(100);
    
    // clear the screen
    writeToLCD(COMMAND, 0x01);

    // give it time to finish    
    wait_ms(2);

    // set entry mode to increment cursor position cursor on write
    writeToLCD(COMMAND, 0x03);
    
    // give it time to finish    
    wait_us(100);

    // position cursor at home
    writeToLCD(COMMAND, 0x02);
    
    // give it time to finish    
    wait_ms(2);

    // display on
    writeToLCD(COMMAND, 0x0C);
}




void positionCursor(uint8_t x, uint8_t y){

    if (x > 7) x = 0;
    
    if (y == 1)
        writeToLCD(COMMAND, 0x80 + 0x40 + x);
    else
        writeToLCD(COMMAND, 0x80 + 0x00 + x);
        
    wait_us(50);
}


void displayString(int x, int y, char *str){
    
    // position cursor
    positionCursor(x, y);    
    
    // write string to screen
    for (int i=0; i<strlen(str); i++){
        writeToLCD(DATA, str[i]);
        
        wait_us(50);
    }
}


 
 void updateDisplay(){
    char str[20];
    
    sprintf( str, "b %5.3f", birefVal);

    displayString(0, 0, str);

    if (birefStdDev <= 0.0)
        birefStdDev = 0.0001;
        
    sprintf( str, "s %5.3f", birefStdDev);

    displayString(0, 1, str);
}
 
 
void rcvCharISR()
{
    float tempf;
    char chr = birefSensor.getc();

    //led1 = !led1;
    
    //pc.printf("%c (%02x)\n", chr, chr);        
    
    rcvBuff[buffIdx++] = chr;
    
    if (buffIdx >= 80)
    {
        buffIdx = 0;
    }
    
    if (chr == '\n')
    {
        rcvBuff[buffIdx] = '\0';
        
        switch (rcvBuff[0]){
            case 'm':
                sscanf(rcvBuff, "m%f %f\n", &birefVal, &birefStdDev);
                birefOut = birefVal;
                break;
            case 'd':
                sscanf(rcvBuff, "d%f %f %f %f %f %f \n", &tempf, &tempf, &tempf, &tempf, &birefVal, &birefStdDev);
                birefOut = birefVal;
                break;
            default: ;
        }
        buffIdx = 0;
    }
}


 
int main() {
    
    initLCD();
    
    birefSensor.baud(115200);
    
    pc.printf("Hello\n");
    
    updateLCD.attach(&updateDisplay, 0.5);

    birefSensor.attach(&rcvCharISR);
    
    while(1) {

        wait(0.02);
        //wait(1.0);
    }
}
