#include "mbed.h"
#include "SRF02.h"
#include "PC2119_16X2_LCD.h"

// ultrasonc sensor has a resolution of 1 cm at best so can only be used for rough positional measurements

// Batron LCD - this code is a bit rough and ready and doesn't cope with the second line of the dsiplay very well

// Adresse I2C standard des afficheurs LCD
#define LCDADDR 0x76

DigitalOut led1(LED1);
DigitalOut led2(LED2);
DigitalOut led3(LED3);
DigitalOut led4(LED4);
DigitalIn multiSensor(p20);
//I2C i2c(p9, p10);
//DigitalOut resetLCD(p11);
//I2C ultraS(p28,p27);
Serial pc(USBTX, USBRX); // tx, rx
SRF02 srf02c(p28, p27, 0xE0, 0x52);
SRF02 srf02l(p28, p27, 0xE2, 0x52);
SRF02 srf02r(p28, p27, 0xE4, 0x52);
AnalogOut anOut(p18);
//PC2119_16X2_LCD lcd(p9, p10, p11);

float filteredDistance = 1000.0;
float range = 4000.0;

// procedure declarations




int main() 
{
 //   char str[10];
//    char msb = 0;
//    char lsb = 0;
    float distanceC;
    float distanceL = range;
    float distanceR = range;
    bool validReading;
    
    // set i2c frequency to 100KHz
    //i2c.frequency(100000);
    
    //pc.printf("clear lcd display\n");
    multiSensor.mode(PullUp);
    
    // do forever
    while (1)
    {
        validReading = false;
        
        distanceC = srf02c.read();
        
        if (multiSensor == true)
        {
            distanceL = srf02l.read();
            distanceR = srf02r.read();
        }
        
        if (distanceC < range)
        {
            led1 = 1;
            validReading = true;
        }
        else
        {
            led1 = 0;
        }
        
        if (multiSensor == true){
            if (distanceL < range)
            {
                led2 = 1;
                validReading = true;
            }
            else
            {
                led2 = 0;
            }
    
            if (distanceR < range)
            {
                led3 = 1;
                validReading = true;
            }
            else
            {
                led3 = 0;
            }
        }
        
        //pc.printf("Distances %5.3f, %5.3f, %5.3f\n", distanceC, distanceL, distanceR);
        
        if (validReading)
        {
            float shortestDistance = 0.0;
            
            if (multiSensor == true){
                if (distanceC < distanceL && distanceC < distanceR)
                    shortestDistance = distanceC;
                else
                    if (distanceL < distanceR)
                        shortestDistance = distanceL;
                    else
                        shortestDistance = distanceR;
            }
            else
                shortestDistance = distanceC;
                            
            filteredDistance = (0.7 * filteredDistance) + (0.3 * shortestDistance);

            pc.printf("Average distance %5.3f\n", filteredDistance);
            
            anOut = filteredDistance / range;
        }
        else
        {
            pc.printf("Out of range\n");
            
            anOut = 0.0;
        }        
        
        // wait a while then loop again - was 20 ms     
        //wait_ms(100);
    }
}

