#include "mbed.h"
#include "C12832.h"               // LCD
 C12832 lcd(p5, p7, p6, p8, p11); // LCD init "  
 
 Serial FsPC(USBTX,USBRX);
 DigitalOut  myled(LED1);         //
      
 char RxData;
 unsigned short EnRX,Index,NdataRx;
 char RxCOMbuffer[50];
 
 unsigned int   RPM_Eng1;
 unsigned int   TrueAirSpeed; 
 int            AltitudeOfAircraft;
 unsigned int   Heading;
 int            Pitch,Roll;
 
void IrqUART_RxPc()
{           
          RxData = FsPC.getc();
          
          if(RxData=='$'){                
                EnRX  = 1; 
                RxCOMbuffer[0]   = 0;
                RxCOMbuffer[1]   = 0;               
                NdataRx=0;
                goto finIrq1;
              }
           if(RxData==0x0D){                
               if((RxCOMbuffer[0]=='F')&&(RxCOMbuffer[1]=='S')){
                  EnRX = 2;                                   
                 }else EnRX = 0;
                 goto finIrq1;                
              }                
            if(EnRX==1){ 
                RxCOMbuffer[NdataRx]=RxData;
                NdataRx++;             
             }              
            finIrq1:asm{nop}; 
                      
} 
 
int main() {
    //P_IrqUART=&IrqUART_RxPc();
    FsPC.baud(19200);
    FsPC.attach(&IrqUART_RxPc,Serial::RxIrq);
    //---------------
    //unsigned short hh,mm,ss;
    unsigned short ENG1_Throttle_lever,ENG1_Starter_Switch;
    unsigned short Elevator_position,Alieron_position,Rudder_position;

    ENG1_Throttle_lever = 50; //0=000%
    ENG1_Starter_Switch = 1;  //0=Off  1=On
    Elevator_position   = 50; //0=min, 50=Null, 100=max 
    Alieron_position    = 50; //0=min, 50=Null, 100=max 
    Rudder_position     = 50; //0=min, 50=Null, 100=max 
    
    lcd.locate(0,10); 
    lcd.printf("TAS ,Alt ,Pit ,Rol ,Cap ,RPM");

    EnRX  = 0;
    Index = 0;
    while(1) {
      
        if(FsPC.writeable()){                                
           FsPC.printf("$FS,%3u,%3u,%3u,%3u,%3u,\r",ENG1_Throttle_lever,ENG1_Starter_Switch,Elevator_position,Alieron_position,Rudder_position);           
        }  
        wait(0.3);
        if(EnRX==2)
        { 
           EnRX=0;                  
           //TrueAirSpeed,AltitudeOfAircraft,Pitch,Roll,Heading,RPM_Eng1         
           sscanf(&RxCOMbuffer[3],"%5u" ,&TrueAirSpeed);          
           sscanf(&RxCOMbuffer[9],"%5u" ,&AltitudeOfAircraft);
           sscanf(&RxCOMbuffer[15],"%5u",&Pitch);          
           sscanf(&RxCOMbuffer[21],"%5u",&Roll);
           sscanf(&RxCOMbuffer[27],"%5u",&Heading);
           sscanf(&RxCOMbuffer[33],"%5u",&RPM_Eng1);         
           Pitch = Pitch-1800;
           Roll  = Roll-1800;

           lcd.locate(0,20);          
           lcd.printf("%3u,%4u,%4d,%4d,%4u,%4u",TrueAirSpeed,AltitudeOfAircraft,Pitch,Roll,Heading,RPM_Eng1);        
          
           //- Exemple : TAS Hold at 70 mph
           if((TrueAirSpeed<700-2)&&(ENG1_Throttle_lever<99))ENG1_Throttle_lever=ENG1_Throttle_lever+1;
           if((TrueAirSpeed>700+2)&&(ENG1_Throttle_lever>1))ENG1_Throttle_lever=ENG1_Throttle_lever-1;
           //- Exemple Roll Stabilization at 0°=1800;
           Alieron_position=50;
           if((Roll<-10))Alieron_position=50-5;
           if((Roll>+10))Alieron_position=50+5;  
           //- Exemple : AltitudeOfAircraft Hold at 1000 m +-5m
           Elevator_position = 50;
           if (AltitudeOfAircraft>6000){
           if(AltitudeOfAircraft<10000-50)Elevator_position=50+10;
           if(AltitudeOfAircraft>10000+50)Elevator_position=50-10;        
          }          
        }          
        myled = !myled ;        
    }
}
