//----------------------------------------------------------------------------
// The confidential and proprietary information contained in this file may
// only be used by a person authorised under and to the extent permitted
// by a subsisting licensing agreement from ARM Limited or its affiliates.
//
// (C) COPYRIGHT 2016 ARM Limited or its affiliates.
// ALL RIGHTS RESERVED
//
// This entire notice must be reproduced on all copies of this file
// and copies of this file may only be made by a person if such person is
// permitted to do so under the terms of a subsisting license agreement
// from ARM Limited or its affiliates.
//----------------------------------------------------------------------------
#include "mbed.h"
#include "config.h"
#include "C12832.h"
#include "OdinWiFiInterface.h"
#include "http_request.h"
#include <string>

C12832  lcd(PE_14, PE_12, PD_12, PD_11, PE_9);
OdinWiFiInterface wifiIF;
NetworkInterface* netIF;
InterruptIn post_button(PF_2);
InterruptIn get_put_button(PG_4);
volatile bool post_clicked = false;
volatile bool get_clicked = false;
volatile bool put_clicked = false;
Timer timeSinceGet;
float getTimer;
Timer timeSinceReport;
float reportTimer;

struct sensorWatcher {
    char sensor;
    uint8_t id;
    uint8_t active;
    float lowThreshold;
    float highThreshold;
};
sensorWatcher alertList[ALERTLISTSIZE];

struct sensorData {
#if USING_TEMPERATURE
    float temperature;
    float humidity;
#endif
#if USING_LIGHT
    float visible;
    float infrared;
#endif
#if USING_AIR
    float co;
    float tvoc;
#endif
#if USING_LASER
    float distance;
#endif
#if USING_ACCEL
    float xAcceleration;
    float yAcceleration;
    float zAcceleration;
#endif  
};
sensorData measurements;

void lcd_print(const char* message) {
    lcd.cls();
    lcd.locate(0, 3);
    lcd.printf(message);
}

void send_post() {
    post_clicked = true;
}
 
void send_get_put() {
    get_clicked = true;
}

void httpPost(const char* body, int msgLen) {
    HttpRequest* request = new HttpRequest(netIF, HTTP_POST, "http://10.25.2.152:8080");
    request->set_header("Content-Type", "application/json");
    HttpResponse* response = request->send(body, msgLen);
    delete request;
}

void addAlert(char* alertData) {
    int ii;
    for(ii=0;alertList[ii].id!=0xff && ii<ALERTLISTSIZE;ii++);
    if(ii<ALERTLISTSIZE){
        alertList[ii].sensor = alertData[0];
        alertList[ii].id = (uint8_t)alertData[1];
        alertList[ii].lowThreshold = *((float*)(&(alertData[2])));
        alertList[ii].highThreshold = *((float*)(&(alertData[6])));
    }
}

void destroyAlert(int alertID) {
    for(int ii=0;ii<ALERTLISTSIZE;ii++) {
        if(alertList[ii].id == (uint8_t)alertID) {
            alertList[ii].id = 0xff;
            alertList[ii].sensor = 'E';
        }
    }
}

void updateTimers(char* timerData) {
    float newGetTmr = *((float*)(&(timerData[0])));
    float newReportTmr = *((float*)(&(timerData[4])));
    
    if(newGetTmr > 131072) {
        getTimer = GETTIMERINIT;
    } else if(newGetTmr != 0) {
        getTimer = newGetTmr;
    }
    
    if(newReportTmr > 131072) {
        newReportTmr = REPORTTIMERINIT;
    } else if(newReportTmr != 0) {
        getTimer = newReportTmr;
    }
}

int main() {

    int ret;
    SocketAddress serverAddr;
    getTimer = GETTIMERINIT;
    reportTimer = REPORTTIMERINIT;
    
    lcd_print("Connecting...");
    ret = wifiIF.connect(MBED_CONF_APP_WIFI_SSID, MBED_CONF_APP_WIFI_PASSWORD, NSAPI_SECURITY_WPA_WPA2);
    if (ret != 0) {
        lcd_print("Connection error.");
        return -1;
    }
    lcd_print("Successfully connected!");
    lcd_print(wifiIF.get_mac_address());
    //wifiIF.gethostbyname(SERVERNAME, &serverAddr);

    /* Enable interrupts */
    post_button.rise(&send_post);
    get_put_button.rise(&send_get_put);
    
    /* Init */
    for(int ii=0;ii<32;ii++) {
        alertList[ii].sensor = 'E';    //E for empty
        alertList[ii].id = 0xff;
    }
    
    /* Main loop */
    netIF = &wifiIF;
    timeSinceGet.start();
    timeSinceReport.start();
    while (1) {
        /* Ask the server if it has any updates */
        if(timeSinceGet.read() > getTimer) {
            HttpRequest* request = new HttpRequest(netIF, HTTP_GET, "http://10.25.2.152:8080");
            request->set_header("Content-Type", "application/json");
            const char body[] = "{\"get\":\"request\"}";
            HttpResponse* response = request->send(body, strlen(body));
            char* arrui8Msg = (char*)response->get_body_as_string().c_str();
            lcd_print(arrui8Msg);
            char chr = arrui8Msg[0];
            if(chr == 'T') {
                updateTimers(&(arrui8Msg[1]));   
            } else if(chr == 'E') {
                if(arrui8Msg[1]=='C') {
                    addAlert(&(arrui8Msg[2]));
                } else if(arrui8Msg[1]=='D') {
                    destroyAlert((uint8_t)arrui8Msg[2]);
                }      
            }
            
            delete request;
            /* Restart timer */
            timeSinceGet.reset();
        }
        /* Send reports periodically */
        if(timeSinceReport.read() > reportTimer) {
            //TODO collect sensor data
            char reportMsg[(USING_TEMPERATURE*2+USING_LIGHT*2+USING_AIR*2+USING_LASER+USING_ACCEL*3+1)*4+2];//+2 because of the 'R' character and the eof
            reportMsg[0] = 'R';
            for(int ii=0;ii<4;ii++){
#if USING_TEMPERATURE
                reportMsg[1+ii]=*(((uint8_t*)(&(measurements.temperature)))+ii);
                reportMsg[5+ii]=*(((uint8_t*)(&(measurements.humidity)))+ii);
#endif
#if USING_LIGHT
                reportMsg[1+8*USING_TEMPERATURE+ii]=*(((uint8_t*)(&(measurements.visible)))+ii);
                reportMsg[5+8*USING_TEMPERATURE+ii]=*(((uint8_t*)(&(measurements.infrared)))+ii);
#endif
#if USING_AIR
                reportMsg[1+8*(USING_TEMPERATURE+USING_LIGHT)+ii]=*(((uint8_t*)(&(measurements.co)))+ii);
                reportMsg[5+8*(USING_TEMPERATURE+USING_LIGHT)+ii]=*(((uint8_t*)(&(measurements.tvoc)))+ii);
#endif
#if USING_LASER
                reportMsg[1+8*(USING_TEMPERATURE+USING_LIGHT+USING_AIR)+ii]=*(((uint8_t)(&(measurements.distance)))+ii);
#endif
#if USING_ACCEL
                reportMsg[1+8*(USING_TEMPERATURE+USING_LIGHT+USING_AIR)+4*USING_LASER+ii]=*(((uint8_t*)(&(measurements.xAcceleration)))+ii);
                reportMsg[1+8*(USING_TEMPERATURE+USING_LIGHT+USING_AIR)+4*USING_LASER+ii]=*(((uint8_t*)(&(measurements.yAcceleration)))+ii);
                reportMsg[1+8*(USING_TEMPERATURE+USING_LIGHT+USING_AIR)+4*USING_LASER+ii]=*(((uint8_t*)(&(measurements.zAcceleration)))+ii);
#endif
            }
            /*char testMsg[13] = "Hello World!";
            testMsg[5] = (char)0x00;
            httpPost(testMsg, 13);*/
            httpPost(reportMsg, (USING_TEMPERATURE*2+USING_LIGHT*2+USING_AIR*2+USING_LASER+USING_ACCEL*3+1)*4+2);
            /* Restart timer */
            timeSinceReport.reset();
        }
        
        /* Check whether or not to send alert */
        uint8_t breach; //0x0f if below lower boundary, 0xf0 if above higher boundary
        uint8_t alertReset;
        for(int ii=0;ii<ALERTLISTSIZE;ii++){
            breach = 0x00;
            alertReset = 0;
            switch(alertList[ii].sensor) {
#if USING_TEMPERATURE
                case 'T':
                    if(!alertList[ii].active) {
                        if(measurements.temperature < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.temperature > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.temperature > alertList[ii].lowThreshold
                                && measurements.temperature < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
                case 'H':
                     if(!alertList[ii].active) {
                        if(measurements.humidity < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.humidity > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.humidity > alertList[ii].lowThreshold
                                && measurements.humidity < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                   break;
#endif
#if USING_LIGHT
                case 'V':
                    if(!alertList[ii].active) {
                        if(measurements.visible < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.visible > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.visible > alertList[ii].lowThreshold
                                && measurements.visible < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
                case 'I':
                     if(!alertList[ii].active) {
                        if(measurements.infrared < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.infrared > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.infrared > alertList[ii].lowThreshold
                                && measurements.infrared < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                   break;
#endif
#if USING_AIR
                case 'C':
                    if(!alertList[ii].active) {
                        if(measurements.co < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.co > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.co > alertList[ii].lowThreshold
                                && measurements.co < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
                case 'O':
                    if(!alertList[ii].active) {
                        if(measurements.tvoc < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.tvoc > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.tvoc > alertList[ii].lowThreshold
                                && measurements.tvoc < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
#endif
#if USING_LASER
                case 'D':
                    if(!alertList[ii].active) {
                        if(measurements.distance < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.distance > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.distance > alertList[ii].lowThreshold
                                && measurements.distance < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
#endif
#if USING_ACCEL
                case 'X':
                    if(!alertList[ii].active) {
                        if(measurements.xAcceleration < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.xAcceleration > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.xAcceleration > alertList[ii].lowThreshold
                                && measurements.xAcceleration < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
                case 'Y':
                    if(!alertList[ii].active) {
                        if(measurements.yAcceleration < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.yAcceleration > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.yAcceleration > alertList[ii].lowThreshold
                                && measurements.yAcceleration < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
                case 'Z':
                    if(!alertList[ii].active) {
                        if(measurements.zAcceleration < alertList[ii].lowThreshold) {
                            alertList[ii].active = 1;
                            breach = 0x0f;
                        } else if(measurements.zAcceleration > alertList[ii].highThreshold) {
                            alertList[ii].active = 1;
                            breach = 0xf0;
                        }
                    } else if( measurements.zAcceleration > alertList[ii].lowThreshold
                                && measurements.zAcceleration < alertList[ii].highThreshold ) {
                        alertList[ii].active = 0;
                        alertReset = 1;        
                    }
                    break;
#endif
                default:
                    break;
            }
            if(breach != 0) {
                char msgBuff[5] = {'A', 'S', (char)alertList[ii].id, (char)breach};
                httpPost(msgBuff, 5);
            } else if(alertReset) {
                char msgBuff[4] = {'A', 'R', (char)alertList[ii].id};
                httpPost(msgBuff, 4);
            }
        }
    }

}
