#include "mbed.h"

// JUMPERS REQUIRED ON MOTOR DRIVER STBY PINS ! PULL TO 3V3.
// Feeder message is FxxTx(L or R)  F= feeder ID, T= teethRequested, (L for left or R for right)
// *************************************************
// FEEDER ID !! Set 10's and 1's (for ID= 13, tens = 1 and ones = 3) USE CHAR!
char tens = '0';
char ones = '1';

               
int teethRequested = 0;      // how many teeth advance has been selected?
int index = 0;               // for parsing serial


Timer timer;

InterruptIn lOpto(P1_31);    
InterruptIn lButton(P1_25);
InterruptIn rOpto(P1_29); 
InterruptIn rButton(P1_26);

//LEDs
DigitalOut lLed(P0_18);
DigitalOut rLed(P1_16);

//Left Tape
DigitalOut lTapeIn1(P1_20);  
DigitalOut lTapeIn2(P1_21);
PwmOut lTapePWM(P1_24);
AnalogIn tapePot(P0_12);          // will be 0 -1024
int tapePotADC;                   // after math will be 0-9 for PWMwrite

//Left motor
DigitalOut lMotorIn1(P0_15);  
DigitalOut lMotorIn2(P0_16);
PwmOut lMotorPWM(P1_24);
int lMotorSet = 5;        // use 1-10 (whole numbers) to set PWM, it is /10 in the function to be float (lMotorSet / 10)

// Right Tape
DigitalOut rTapeIn1(P0_22);  
DigitalOut rTapeIn2(P0_21);
PwmOut rTapePWM(P1_24);

//Right motor
DigitalOut rMotorIn1(P0_23);  
DigitalOut rMotorIn2(P1_15);
PwmOut rMotorPWM(P1_24);
int rMotorSet = 5;        // use 1-10 (whole numbers) to set PWM, it is /10 in the function to be float (lMotorSet / 10)

//////////////////////////////////////////////////////////

void lFeed(){
    if (teethRequested == 0){    // this is just for the button, if over serial then teethrequested has already been set to > 0
        teethRequested = 1;     // change to how many teeth you want the button to feed
        }  
    
    //Tape
    lTapeIn1 = 0;                      // reverse 1's and 0's if rotation is backwards
    lTapeIn2 = 1;
    lTapePWM.write((tapePotADC / 10));  // from POT , max 0.9 with this code as ADC value is being divided by 103
    
    //Motor                                    
    lMotorIn1 = 0;
    lMotorIn2 = 1;
    lMotorPWM.write(lMotorSet / 10); 
    }
    
void rFeed(){
    if (teethRequested == 0){    // this is just for the button, if over serial then teethrequested has already been set to > 0
        teethRequested = 1;     // change to how many teeth you want the button to feed
        }  
    
    //Tape
    rTapeIn1 = 0;                      // reverse 1's and 0's if rotation is backwards
    rTapeIn2 = 1;
    rTapePWM.write((tapePotADC / 10));  // from POT , max 0.9 with this code as ADC value is being divided by 103
    
    //Motor                                    
    rMotorIn1 = 0;
    rMotorIn2 = 1;
    rMotorPWM.write(lMotorSet / 10); 
    }
            
void lStop(){
    if (teethRequested == 1){                        // If only one (or one more) tooth needed to be driven
                 
    //tape
    lTapeIn1 = 0;
    lTapeIn2 = 0;
    lTapePWM.write(0.0f); //PWM off
        
    //motor
    lMotorIn1 = 0;
    lMotorIn2 = 0;
    lMotorPWM.write(0.0f); //PWM off
    teethRequested = 0;                               // set teeth requested to zero so it will ignore further opto interrupts.
    }
    
    if (teethRequested <=2){                      // If more than one tooth needs to be driven, skip this interrupt and decrement 
    teethRequested = (teethRequested - 1);
    }
    }
    
    void rStop(){
    if (teethRequested == 1){                        // If only one (or one more) tooth needed to be driven
                 
    //tape
    rTapeIn1 = 0;
    rTapeIn2 = 0;
    rTapePWM.write(0.0f); //PWM off
        
    //motor
    rMotorIn1 = 0;
    rMotorIn2 = 0;
    rMotorPWM.write(0.0f); //PWM off
    teethRequested = 0;                               // set teeth requested to zero so it will ignore further opto interrupts.
    }
    
    if (teethRequested <=2){                      // If more than one tooth needs to be driven, skip this interrupt and decrement 
    teethRequested = (teethRequested - 1);
    }
    }
 
 // SERIAL
 
 Serial device(P1_13, P1_14);  // RS 485
 
 
int main() {
    
lOpto.mode(PullNone);     // external pull up               
lButton.mode(PullUp);     // button pull up
rOpto.mode(PullNone);
    
lOpto.fall(&lStop);
lButton.fall(&lFeed);

 uint8_t c = 0;
device.printf("Hello World\n");
    
    while(1) {
        
// TODO create timer for USB debug messages 

while (device.readable())
            {
                c = device.getc();
                if (c == 'F'){
                    index = 1;
                    }
                
                if (index == 1){    
                    if (c == tens){
                        index = 2;
                        }
                        }
                
                if (index == 2){
                    if (c == ones);{
                        index = 3;
                        }
                        }
                        
                if (index == 3){
                    if (c == '1'){
                        teethRequested = 1;
                        }
                    else if (c == '2'){
                        teethRequested = 2;
                        }
                    else if (c == '3'){
                        teethRequested = 3;
                        }
                    else if (c == '4'){
                        teethRequested = 4;
                        }
                        index = 4;
                        }
                        
                if (index == 4){
                        if (c == 'L'){
                            lFeed();
                            index = 0;
                            }
                            }
                        if (c == 'R'){
                            rFeed();
                            index = 0;
                            }
                            }
                        
                
tapePotADC = ((tapePot)/ 103);   // covert 1024 to (1 -9) for the PWM setting.
        

        
if(lOpto){
lLed = 0;}
else{
lLed = 1;
}
}
    
}
