#include "mbed.h"
#include "USBSerial.h"
#include "QEI.h"

// JUMPERS REQUIRED ON MOTOR DRIVER STBY PINS ! PULL TO 3V3.
// Feeder message is FxxTx(L or R)  F= feeder ID, T= teethRequested, (L for left or R for right)
// *************************************************
// FEEDER ID !! Set 10's and 1's (for ID= 13, tens = 1 and ones = 3) USE CHAR!
char tens = '0';
char ones = '1';

               
int teethRequested = 0;      // how many teeth advance has been selected?
int index = 0;               // for parsing serial

//Encoder:

QEI lEncoder(P0_13, P0_14, NC, 1440, QEI::X4_ENCODING);
int startEncoder = 0;
int encoderTarget = 0;

Timer timer;

InterruptIn lOpto(P1_29);    
InterruptIn lButton(P1_22);
InterruptIn rOpto(P1_26); 
InterruptIn rButton(P0_20);

//LEDs
DigitalOut lLed(P0_11);
DigitalOut rLed(P0_2);

//Left Tape
DigitalOut lTapeIn1(P0_10);  
DigitalOut lTapeIn2(P0_9);
PwmOut lTapePWM(P0_8);
AnalogIn tapePot(P0_15);          // will be 0 -1024
int tapePotADC;                   // after math will be 0-9 for PWMwrite

//Left motor
DigitalOut lMotorIn1(P1_15);  
DigitalOut lMotorIn2(P0_23);
PwmOut lMotorPWM(P0_19);
int lMotorSet = 5;        // use 1-10 (whole numbers) to set PWM, it is /10 in the function to be float (lMotorSet / 10)

// Right Tape
DigitalOut rTapeIn1(P1_21);  
DigitalOut rTapeIn2(P1_31);
PwmOut rTapePWM(P0_8);

//Right motor
DigitalOut rMotorIn1(P0_17);  
DigitalOut rMotorIn2(P0_18);
//PwmOut rMotorPWM(P0_19);
int rMotorSet = 5;        // use 1-10 (whole numbers) to set PWM, it is /10 in the function to be float (lMotorSet / 10)

//////////////////////////////////////////////////////////

void lFeed(){
    
    /*
    if (teethRequested == 0){    // this is just for the button, if over serial then teethrequested has already been set to > 0
        teethRequested = 1;     // change to how many teeth you want the button to feed
        }  
    
    //Tape
    lTapeIn1 = 0;                      // reverse 1's and 0's if rotation is backwards
    lTapeIn2 = 1;
   // lTapePWM.write(0.5f);  // from POT , max 0.9 with this code as ADC value is being divided by 103
    
    //Motor
    
    
    
    while (lEncoder.getPulses() < (startEncoder + 45)){                                    
    lMotorIn1 = 0;
    lMotorIn2 = 1;
    lMotorPWM.write(0.5); 
    }
    
    lMotorIn1 = 1;
    lMotorIn2 = 1;
    lMotorPWM.write(0.0f); //PWM off
    teethRequested = 0;                               // set teeth requested to zero so it will ignore further opto interrupts.
    }
    */
    
    startEncoder = lEncoder.getPulses();
    encoderTarget = (startEncoder + 12);
    }
    
void rFeed(){
    if (teethRequested == 0){    // this is just for the button, if over serial then teethrequested has already been set to > 0
        teethRequested = 1;     // change to how many teeth you want the button to feed
        }  
    
    //Tape
    rTapeIn1 = 0;                      // reverse 1's and 0's if rotation is backwards
    rTapeIn2 = 1;
    rTapePWM.write((tapePotADC / 10));  // from POT , max 0.9 with this code as ADC value is being divided by 103
    
    //Motor                                    
    rMotorIn1 = 0;
    rMotorIn2 = 1;
   // rMotorPWM.write(lMotorSet / 10); 
    }
            
void lStop(){
   // if (teethRequested >= 1){                        // If only one (or one more) tooth needed to be driven
                 
    //tape
    lTapeIn1 = 0;
    lTapeIn2 = 0;
    lTapePWM.write(0.0f); //PWM off
        
    //motor
    lMotorIn1 = 1;
    lMotorIn2 = 1;
    lMotorPWM.write(0.0f); //PWM off
    teethRequested = 0;                               // set teeth requested to zero so it will ignore further opto interrupts.
    }
   
   
   // if (teethRequested <=2){                      // If more than one tooth needs to be driven, skip this interrupt and decrement 
   // teethRequested = (teethRequested - 1);
  //  }
  //  }
    
    void rStop(){
    if (teethRequested == 1){                        // If only one (or one more) tooth needed to be driven
                 
    //tape
    rTapeIn1 = 0;
    rTapeIn2 = 0;
    rTapePWM.write(0.0f); //PWM off
        
    //motor
    rMotorIn1 = 0;
    rMotorIn2 = 0;
 //   rMotorPWM.write(0.0f); //PWM off
    teethRequested = 0;                               // set teeth requested to zero so it will ignore further opto interrupts.
    }
    
    if (teethRequested <=2){                      // If more than one tooth needs to be driven, skip this interrupt and decrement 
    teethRequested = (teethRequested - 1);
    }
    }
 
 // SERIAL
 
 //Serial device(P1_13, P1_14);  // RS 485
 
// USB VCOM UART for MBED Serial Port Driver




 
 
int main() {
    
lOpto.mode(PullNone);     // external pull up               
lButton.mode(PullUp);     // button pull up
rOpto.mode(PullNone);
    
lOpto.rise(&lStop);
lButton.fall(&lFeed);

  uint8_t c = 0;
//device.printf("Hello World\n");

USBSerial serial;
serial.printf("I am a virtual serial port\r\n");
    
    while(1) {
        
// TODO create timer for USB debug messages 

        serial.printf("Encoder pulses: %i\n", lEncoder.getPulses());
        serial.printf("Encoder state: %i\n", lEncoder.getCurrentState ());
        wait(1);
        
    while (lEncoder.getPulses() < encoderTarget){                                    
    lMotorIn1 = 0;
    lMotorIn2 = 1;
    lMotorPWM.write(0.5); 
    }
    
    lMotorIn1 = 1;
    lMotorIn2 = 1;
    lMotorPWM.write(0.0f); //PWM off
    teethRequested = 0;                               // set teeth requested to zero so it will ignore further opto interrupts.
        
        
        

/*
while (device.readable())
            {
                c = device.getc();
                if (c == 'F'){
                    index = 1;
                    }
                
                if (index == 1){    
                    if (c == tens){
                        index = 2;
                        }
                        }
                
                if (index == 2){
                    if (c == ones);{
                        index = 3;
                        }
                        }
                        
                if (index == 3){
                    if (c == '1'){
                        teethRequested = 1;
                        }
                    else if (c == '2'){
                        teethRequested = 2;
                        }
                    else if (c == '3'){
                        teethRequested = 3;
                        }
                    else if (c == '4'){
                        teethRequested = 4;
                        }
                        index = 4;
                        }
                        
                if (index == 4){
                        if (c == 'L'){
                            lFeed();
                            index = 0;
                            }
                            }
                        if (c == 'R'){
                            rFeed();
                            index = 0;
                            }
                            }
                        
           */    
tapePotADC = ((tapePot)/ 103);   // covert 1024 to (1 -9) for the PWM setting.
        

        
if(lOpto){
lLed = 0;}
else{
lLed = 1;

if(rOpto){
rLed = 0;}
else{
rLed = 1;

}
}
    
}
}