#include "mbed.h"

AnalogIn   F1p(PA_0); 
AnalogIn   F1n(PA_1);
AnalogIn   F2p(PA_4);
AnalogIn   F2n(PB_0);
AnalogIn   F3p(PC_1);
AnalogIn   F3n(PC_0);

DigitalOut myled(PA_5);
PwmOut M1(PA_6);
PwmOut M2(PA_7);
PwmOut M3(PB_6);

Serial UART(SERIAL_TX, SERIAL_RX);

int main() {
    float w1 = 1025, w2 = 620, w3 = 1365;
    int i;
    float fb1 = 0, fb2 = 0, fb3 = 0;
    char c;
    M1.period_ms(20);
    M2.period_ms(20);
    M3.period_ms(20);
   
    M1.pulsewidth_us(1900);
    M2.pulsewidth_us(600);
    M3.pulsewidth_us(2000);
    wait(2.0f);
    
    M1.pulsewidth_us(1047);
    M2.pulsewidth_us(600);
    M3.pulsewidth_us(2000);
    wait(2.0f);
    
    M1.pulsewidth_us(1047);
    M2.pulsewidth_us(600);
    M3.pulsewidth_us(1402);
    wait(2.0f);
    
    M1.pulsewidth_us(1053);
    M2.pulsewidth_us(591);
    M3.pulsewidth_us(1374);
    wait(2.0f);
    
    w1 = 1053;
    w2 = 591;
    w3 = 1347;
    
    //=============================================
    
    /*
    M1.pulsewidth_us(1000);
    M2.pulsewidth_us(626);
    M3.pulsewidth_us(1369);
    wait(1.0f);
    
    M1.pulsewidth_us(990);
    M2.pulsewidth_us(640);
    M3.pulsewidth_us(1377);
    wait(1.0f);
    
    M1.pulsewidth_us(980);
    M2.pulsewidth_us(664);
    M3.pulsewidth_us(1379);
    wait(1.0f);
    
    M1.pulsewidth_us(970);
    M2.pulsewidth_us(688);
    M3.pulsewidth_us(1391);
    wait(1.0f);
    
    M1.pulsewidth_us(960);
    M2.pulsewidth_us(694);
    M3.pulsewidth_us(1397);
    wait(1.0f);
    
    M1.pulsewidth_us(950);
    M2.pulsewidth_us(724);
    M3.pulsewidth_us(1401);
    wait(1.0f);
    
    M1.pulsewidth_us(940);
    M2.pulsewidth_us(752);
    M3.pulsewidth_us(1415);
    wait(1.0f);
    
    M1.pulsewidth_us(930);
    M2.pulsewidth_us(762);
    M3.pulsewidth_us(1424);
    wait(1.0f);
    
    M1.pulsewidth_us(927);
    M2.pulsewidth_us(766);
    M3.pulsewidth_us(1428);
    wait(1.0f);
    
    M1.pulsewidth_us(921);
    M2.pulsewidth_us(778);
    M3.pulsewidth_us(1434);
    wait(1.0f);
    
    M1.pulsewidth_us(913);
    M2.pulsewidth_us(794);
    M3.pulsewidth_us(1442);
    wait(1.0f);
    
    M1.pulsewidth_us(901);
    M2.pulsewidth_us(826);
    M3.pulsewidth_us(1458);
    wait(1.0f);
    */
    /*
    M1.pulsewidth_us(970);
    wait(1.0f);
    M2.pulsewidth_us(680);
    M3.pulsewidth_us(1349);
    wait(1.0f);*/
    
    
    UART.baud(9600); // Set BuadRate
    printf("PW1 = %f us,PW2 = %f us,PW3 = %f us \n\r",w1,w2,w3);
    while(1) {
        c = UART.getc();
        if(c == '1')
        {
            w1 = w1 + 2;
        }
        else if(c == '2')
        {
            w1 = w1 - 2;
        }
        else if(c == '3')
        {
            w2 = w2 + 2;
        }
        else if(c == '4')
        {
            w2 = w2 - 2;
        }
        else if(c == '5')
        {
            w3 = w3 + 2;
        }
        else if(c == '6')
        {
            w3 = w3 - 2;
        }
        
        printf("PW1 = %f us,PW2 = %f us,PW3 = %f us \n\r",w1,w2,w3);
        M1.pulsewidth_us(w1);
        M2.pulsewidth_us(w2);
        M3.pulsewidth_us(w3);
        
        for(i=0;i<=9;i++)
        {
            fb1 = fb1 + ((F1p-F1n)*3.3f);
            fb2 = fb2 + ((F2p-F2n)*3.3f);
            fb3 = fb3 + ((F3p-F3n)*3.3f);
        }
        printf("FB1 = %f V, FB2 = %f V, FB3 = %f V\r\r\n",(fb1/10),(fb2/10),(fb3/10));
        fb1 = 0;
        fb2 = 0;
        fb3 = 0;
        myled = !myled;
        }
}
