#include "mbed.h"
#include "TSISensor.h"
#include "MMA8451Q.h"

#if   defined (TARGET_KL25Z) || defined (TARGET_KL46Z)
  PinName const SDA = PTE25;
  PinName const SCL = PTE24;
#elif defined (TARGET_KL05Z)
  PinName const SDA = PTB4;
  PinName const SCL = PTB3;
#elif defined (TARGET_K20D50M)
  PinName const SDA = PTB1;
  PinName const SCL = PTB0;
#else
  #error TARGET NOT DEFINED
#endif

#define MMA8451_I2C_ADDRESS (0x1d<<1)

int main(void) {
    
    MMA8451Q acc(SDA, SCL, MMA8451_I2C_ADDRESS);
        
    PwmOut RED(LED1);   //Declare RGB LEDs
    PwmOut GREEN(LED2);
    PwmOut BLUE(LED3);
    
    TSISensor tsi;
    
    float just_logged = 0.9; //variable for holding new slider value
    float last_logged = 0.9; //variable for holding previous value
    
    while (true) {    //accelerometer will be read on every iteration,
                      //regardless of slider value.
    
       if (tsi.readPercentage()) //is slider being touched?
        {
            just_logged = tsi.readPercentage(); //store new value
            
            if (tsi.readPercentage()>0.9) //don't allow value near 1, as LEDs will go off
            {
                just_logged = 0.9;
            }
            
        //UPDATE THE LEDS WITH ACCEL. DATA AND NEW SLIDE DATA    
        RED = 1.0 - ((abs(acc.getAccX())) - (just_logged));
        RED = (RED > 0.99) ? 0.99 : RED; //here we are ensuring the LEDs never go fully off.
                                         //this could of course be changed to allow them to
        
        GREEN = 1.0 - ((abs(acc.getAccY())) - (just_logged));
        GREEN = (GREEN > 0.99) ? 0.99 : GREEN;
        
        BLUE = 1.0 - ((abs(acc.getAccZ())) - (just_logged));
        BLUE = (BLUE > 0.99) ? 0.99 : BLUE;
        
        last_logged = tsi.readPercentage();
        
        wait(0.1);
        }
        
        else // no new slider data, therefore use previous
        {
        RED = 1.0 - ((abs(acc.getAccX())) - (last_logged));
        RED = (RED > 0.99) ? 0.99 : RED;
        
        GREEN = 1.0 - ((abs(acc.getAccY())) - (last_logged));
        GREEN = (GREEN > 0.99) ? 0.99 : GREEN;
        
        BLUE = 1.0 - ((abs(acc.getAccZ())) - (last_logged));
        BLUE = (BLUE > 0.99) ? 0.99 : BLUE;
        
        wait(0.1);
        }
        
    }
}