#ifndef _PING_H_
#define _PING_H_

#include "lwip/opt.h"
#include "lwip/mem.h"
#include "lwip/raw.h"
#include "lwip/icmp.h"
#include "lwip/netif.h"
#include "lwip/sys.h"
#include "lwip/timers.h"
#include "lwip/inet_chksum.h"
#include "lwip/sockets.h"
#include "lwip/inet.h"

#ifndef PING_RCV_TIMEO                              //ping timeout... geen antwoord binnen deze tijd => timeout request
#define PING_RCV_TIMEO 1000
#endif

#ifndef PING_ID
#define PING_ID        0x2601                       //identifier om te matchen (antwoord matched hiermee. Linux => uniek, Windows => vast, maar wel verschillend per versie)
#endif

#ifndef PING_DATA_SIZE                              //grootte payload: "random" data die ook gematched moet worden in het antwoord
#define PING_DATA_SIZE 32
#endif

#ifndef PING_DELAY                                  
#define PING_DELAY     500
#endif

#ifndef PING_RESULT
#define PING_RESULT(ping_ok)
#endif

/*-----------------------------------------------------------*/

uint32_t ul_Ping( ip_addr_t *x_PingTarget );
void v_MaakPingRequest( struct icmp_echo_hdr *x_ICMPEchoHdr, uint16_t us_Lenght );
void v_PingOntvang( int32_t l_SocketReturn );
err_t ux_Ping( int32_t l_SocketReturn, ip_addr_t *x_IPAddr );

static uint16_t us_PingSequenceNummer;

/*-----------------------------------------------------------*/

#endif
