#ifndef MAIN_H
#define MAIN_H

#include "mbed.h"

#include "stdint.h"

#include "rtos.h"
#include "EthernetInterface.h"

#include "TS_DISCO_F746NG.h"
#include "LCD_DISCO_F746NG.h"

#include "ping.h"


#ifndef NTP_SERVER_ADDRESS                                  
#define NTP_SERVER_ADDRESS          "1.be.pool.ntp.org"
#endif

#ifndef NTP_SERVER_ADDRESS_IP
#define NTP_SERVER_ADDRESS_IP       "185.77.199.1"
#endif

#ifndef NTP_SERVER_PORT                                  
#define NTP_SERVER_PORT             123                     
#endif


#ifndef NTP_PACKET_SIZE
#define NTP_PACKET_SIZE     48
#endif


/*-----------------------------------------------------------*/

struct Network
{
    char c_Netmask[16];
    char c_Gateway[16];
    char c_IPAddress[16];
    char c_MACAddress[16];
};


EthernetInterface Eth;
LCD_DISCO_F746NG display;
TS_DISCO_F746NG Touch;


/*-----------------------------------------------------------*/

int32_t l_ResetDisplay( void );
int32_t l_ShowSettings( void );
int32_t l_sendNTPpacket(void);

/*-----------------------------------------------------------*/

#endif