#include "main.h"

int32_t l_ResetDisplay( void )
{
    display.Clear( LCD_COLOR_WHITE );
    display.SetBackColor( LCD_COLOR_WHITE );
    display.SetTextColor( LCD_COLOR_BLACK );
    return 0;
}

/*-----------------------------------------------------------*/

int32_t ul_IpStringToNumber( char* pux_IpAddr, uint32_t * pul_IpAddr )
{
   uint8_t uc_Byte3;
   uint8_t uc_Byte2;
   uint8_t uc_Byte1;
   uint8_t uc_Byte0;
   char ux_DummyString[2];                  //dummy -> als er na %ls nog een char komt -> geen correct adres

   if ( sscanf( pux_IpAddr, "%u.%u.%u.%u%1s", &uc_Byte3, &uc_Byte2, &uc_Byte1, &uc_Byte0, ux_DummyString ) == 4 )
   {
      if( ( uc_Byte3 < 256 ) && ( uc_Byte2 < 256 ) && ( uc_Byte1 < 256 ) && ( uc_Byte0 < 256 ) )
      {
         *pul_IpAddr = ( uc_Byte3 << 24 ) + ( uc_Byte2 << 16 ) + ( uc_Byte1 << 8 ) +  uc_Byte0;
         return 1;
      }
   }

   return 0;
}

/*-----------------------------------------------------------*/

int32_t ul_ShowDevices( void )
{
    uint32_t ul_GenIP = 0;
    uint32_t ul_MyIP = 0;
    uint32_t ul_Counter =0;
    uint32_t ul_DevCounter = 0;
    
    ul_IpStringToNumber(Eth.getIPAddress( ) , &ul_MyIP);
    
    ip_addr_t x_ActDev[255];                     //max 255 adressen binnen sub, beter is malloc gebruik en redefine van array/vector => max IP adressen haalbaar: 4228250625
    
    ul_GenIP = ul_MyIP & 0xFFFFFF00;
    display.SetFont( &Font16 );
    display.DisplayStringAt( 10, 120, ( uint8_t * )"PING: ", LEFT_MODE ); 
    
    for( ul_Counter = 1; ul_Counter < 255; ul_Counter++)
    {
        ul_GenIP++;
        if( ul_Ping( ( ip_addr_t * ) ul_GenIP ) == 0 )
        {
            ip_addr_t ux_ConIP = { ul_GenIP };
            x_ActDev[ul_DevCounter] = ux_ConIP;                          //voor een of andere reden is dit de enige manier dat werkt
            display.DisplayStringAt( 10, ( ul_DevCounter * 10 ) + 120 , ( uint8_t * )ul_GenIP, LEFT_MODE );
            ul_DevCounter++;
        }
    }  
    
    return 0;
}

/*-----------------------------------------------------------*/

int32_t l_ShowSettings( void )
{
    l_ResetDisplay( );
    display.SetFont( &Font16 );
    display.DisplayStringAt( 10, 10, ( uint8_t * )"Starting application", LEFT_MODE ); 
    display.DisplayStringAt( 10, 30, ( uint8_t * )"Initiating EthernetInterface", LEFT_MODE ); 
    if( Eth.init( ) == 0 )
    {
        display.DisplayStringAt( 10, 50, ( uint8_t * )"Initiating EthernetInterface: done", LEFT_MODE );
        display.DisplayStringAt( 10, 70, ( uint8_t * )"Connecting to EthernetInterface", LEFT_MODE );
        
        char c_NewIP[16];
        Eth.connect( );
        display.DisplayStringAt( 10, 90, ( uint8_t * )"Initiating EthernetInterface: done", LEFT_MODE );
        display.DisplayStringAt( 10, 110, ( uint8_t * )"Receiving network information", LEFT_MODE );        
        
        strncpy( c_NewIP, Eth.getIPAddress( ), 16 );
        l_ResetDisplay( );
        
        display.DisplayStringAt( 130, 10, ( uint8_t * )"IP address: ", LEFT_MODE ); 
        display.DisplayStringAt( 270, 10, ( uint8_t * )c_NewIP, LEFT_MODE );  
        display.DisplayStringAt( 130, 30, ( uint8_t * )"Netmask: ", LEFT_MODE ); 
        display.DisplayStringAt( 270, 30, ( uint8_t * )Eth.getNetworkMask( ), LEFT_MODE ); 
        display.DisplayStringAt( 130, 50, ( uint8_t * )"Gateway: ", LEFT_MODE ); 
        display.DisplayStringAt( 270, 50, ( uint8_t * )Eth.getGateway( ), LEFT_MODE );
        display.DisplayStringAt( 130, 70, ( uint8_t * )"Internet: ", LEFT_MODE ); 
        l_sendNTPpacket();
    }
    
    return 0;
}

/*-----------------------------------------------------------*/
int32_t l_sendNTPpacket(void)
{
    UDPSocket x_Sock;
    int32_t l_ErrorCatch;
    uint32_t ul_Epoch;  
    uint16_t us_LowWord;
    uint16_t us_HighWord; 
    uint8_t uc_PacketBuffer[NTP_PACKET_SIZE];
    
    uc_PacketBuffer[0] = 0b11100011;
    uc_PacketBuffer[1] = 0;
    uc_PacketBuffer[2] = 6;
    uc_PacketBuffer[3] = 0xEC;
    uc_PacketBuffer[12] = 49;
    uc_PacketBuffer[13] = 0x4E;
    uc_PacketBuffer[14] = 49;
    uc_PacketBuffer[15] = 52;
    
    l_ErrorCatch = x_Sock.init();
    
    if( l_ErrorCatch == -1 )
    {
        display.DisplayStringAt( 270, 70, ( uint8_t * )"Not Connected" , LEFT_MODE );
        return -1;
    }
    
    Endpoint x_NTPServer;
    l_ErrorCatch = x_NTPServer.set_address(NTP_SERVER_ADDRESS, NTP_SERVER_PORT);
    if( l_ErrorCatch == -1 )
    {
        l_ErrorCatch = x_NTPServer.set_address(NTP_SERVER_ADDRESS_IP, NTP_SERVER_PORT);
        if( l_ErrorCatch == -1 )
        {
            display.DisplayStringAt( 270, 70, ( uint8_t * )"Not Connected" , LEFT_MODE );
            return -2;
        }
    }
    
    l_ErrorCatch= x_Sock.sendTo(x_NTPServer, ( char* )uc_PacketBuffer, NTP_PACKET_SIZE);
    
    if( l_ErrorCatch == -1 )
    {
        display.DisplayStringAt( 270, 70, ( uint8_t * )"Not Connected" , LEFT_MODE );
        return -1;
    }
    
    l_ErrorCatch = x_Sock.receiveFrom(x_NTPServer, ( char* ) uc_PacketBuffer, NTP_PACKET_SIZE);

    if( l_ErrorCatch == -1 )
    {
        display.DisplayStringAt( 270, 70, ( uint8_t * )"Not Connected" , LEFT_MODE );
        return -1;
    }
    
    us_HighWord = (uc_PacketBuffer[40] << 8 ) | uc_PacketBuffer[41];
    us_LowWord = (uc_PacketBuffer[42] << 8 ) | uc_PacketBuffer[43];
    ul_Epoch = ((us_HighWord << 16) | us_LowWord );
    ul_Epoch = ul_Epoch - 2208988800;
    
    display.SetFont( &Font16 );
    display.DisplayStringAt( 270, 70, ( uint8_t * )"Connected" , LEFT_MODE );
    
    x_Sock.close();
    return 0;
}

/*-----------------------------------------------------------*/

int main( void )
{   
    l_ShowSettings( );
    ul_ShowDevices( );
    Eth.disconnect();
}