#ifndef DMX_H
#define DMX_H

#include "mbed.h"

enum DMX_STATUS {
    BEGIN,
    START,
    BREAK,
    MAB,
    DATA,
    STOP,
};

class DMX 
{
    public:
        DMX (PinName p_tx, PinName p_rx); 
        void V_PutData(int addr, int data);
        
        void V_Start ();
        void V_Stop ();
    
    private:
        
        Serial _dmx;                                                //seriele poort / uart voor dmx gebruiken
        Timeout T_Timer;   
        LPC_UART_TypeDef *_uart;                                    //definitie om uart te kunnen gebruiken als cross fucntie gebruik
        
        void V_InitTimer();
        void V_InitSend ();
    
        volatile DMX_STATUS ZendStatus;
        volatile uint32_t I32_m_Addr;
        uint8_t I8_Data[512];
};

#endif