#include "DMX.h"

DMX::DMX (PinName p_tx, PinName p_rx) : _dmx(p_tx, p_rx) 
{
    uint32_t I32_Teller;
    
    for (I32_Teller = 0; I32_Teller < 512; I32_Teller++) 
    {
        I8_Data[I32_Teller] = 0;
    }
    
    ZendStatus = STOP;
    if (p_tx == p9) 
    {
      _uart = LPC_UART3;
      NVIC_SetPriority(UART3_IRQn, 1);
    } 
    else if (p_tx == p13) 
    {
      _uart = (LPC_UART_TypeDef*)LPC_UART1;
      NVIC_SetPriority(UART1_IRQn, 1);
    } 
    else if (p_tx == p28) 
    {
      _uart = LPC_UART2;
      NVIC_SetPriority(UART2_IRQn, 1);
    }
    _dmx.baud(250000);
    _dmx.format(8, Serial::None, 2);                                                                // 8 databits, 2 stopbits

}

void DMX::V_PutData (int addr, int data) {
    if ((addr < 0) or (addr >= 512)) 
    {
        return;
    }
    I8_Data[addr] = data;
}

void DMX::V_InitTimer() 
{
    switch (ZendStatus) 
    {
        case BEGIN:
        {
            T_Timer.detach();
            _uart->LCR |= (1 << 6);
            ZendStatus = BREAK;
            T_Timer.attach_us(this, &DMX::V_InitTimer, BREAK);
            break;
        }
        
        case BREAK:
        {
            T_Timer.detach();
            _uart->LCR &= ~(1 << 6);
            ZendStatus = MAB;
            T_Timer.attach_us(this, &DMX::V_InitTimer, MAB);
            break;
        }
        case MAB:
        {
            T_Timer.detach();
            I32_m_Addr = 0;
            ZendStatus = DATA;
            _dmx.attach(this, &DMX::V_InitSend, Serial::TxIrq);
            while(!(_uart->LSR & (1<<5)));
            _uart->THR = 0;                                                         //startcode 0 => Algemene startcode voor dimmer (eigenlijk alles dus wat gewone dmx betreft)
            break;
        }
        default:
        {
            printf("Error: DMX StATUS NIET GEKEND");
            break;
        }
    }
}

void DMX::V_InitSend() 
{
    if (ZendStatus == DATA) 
    {
        if (I32_m_Addr < 512) 
        {
            _uart->THR = I8_Data[I32_m_Addr];
            I32_m_Addr++;
        } 
        else 
        {
            _dmx.attach(0, Serial::TxIrq);                                                  //TxIrq Interrupt zetten om serieel te verzenden :)
            ZendStatus = BEGIN;
            T_Timer.attach_us(this, &DMX::V_InitTimer, 10);
        }
    }
}

void DMX::V_Start() 
{
    if (ZendStatus == STOP) 
    {
        ZendStatus = BEGIN;
        T_Timer.attach_us(this, &DMX::V_InitTimer, 10);
    }
}

void DMX::V_Stop () 
{
    _dmx.attach(NULL, Serial::TxIrq);                                                          //dmx stoppen doorinterrupt te laten verwijzen naar NULL-pointer
    T_Timer.detach();
    ZendStatus = STOP;
}
