#include "mbed.h"
#include "TextLCD.h"

TextLCD lcd(p24, p26, p27, p28, p29, p30);

//#include <stdio.h>
//#include <stdlib.h>  /* 乱数発生用の関数を使用するためのヘッダーファイル */
#define NPLAYERS 4   /* プレーヤの人数 */

#define NGAMES 20000 /* ゲームのシミュレーション回数 */

/* トランプの種類: クラブ，ダイアモンド，ハート，スペード */
#define CLUB 0
#define DIAMOND 1
#define HEART 2
#define SPADE 3

struct card { /* トランプ構造体の定義                   */
  int pips;   /* 数字：1から13まで                      */
  int suit;   /* 種類：クラブ，ダイア，ハート，スペード */
};

/* main()から呼ぶ関数のプロトタイプの宣言 */
void init_card(struct card deck[]);
void shuffle(struct card deck[]);
void deal(struct card deck[], struct card hand[][5]);
int is_straight(struct card h[]);
int is_flush(struct card h[]);
int is_fullhouse(struct card h[]);

void print_deck(struct card deck[]);
void print_hand(struct card deck[]);

struct card deck[52];                 /* カード52枚分を宣言 */
struct card hand[NPLAYERS][5];        /* 4人のプレーヤを宣言 */

int main(void) {
  int i, j;                             /* i=ゲーム回数，j=プレーヤの人数 */
  int straights = 0, flushes = 0, fullhouses = 0; /* それぞれの当たりの数 */

  srand(1);                             /* 乱数の初期化 */
  init_card(deck);                      /* 課題１：カードの初期化 */
  //print_deck(deck);
  shuffle(deck);
  //print_deck(deck);
  lcd.cls();
  lcd.locate(0, 0);
  for (i = 0; i < NGAMES; i++) {       /* NGAMES回ゲームを行なう */
    shuffle(deck);          /* 課題２：カードのシャッフルと分配 */
    deal(deck, hand);       /* 課題２：カードのシャッフルと分配 */
    if (i == 0) {
      print_hand(hand[0]);
    }
    for (j = 0; j < NPLAYERS; j++) {    /* 各プレーヤの手の内をチェック */
      if (is_straight(hand[j])) {       /* 課題３：ストレートか？ */
        straights++;
      }
      if (is_flush(hand[j])) {          /* 課題３：フラッシュか？ */
        flushes++;
      }
      if (is_fullhouse(hand[j])) {      /* 課題３：フルハウスか？ */
        fullhouses++;
      }
    }
  }
  lcd.locate(0, 1);
  lcd.printf("%d, %d, %d", straights, flushes, fullhouses);
  return 0;
}

/* ここからが関数の定義 */

void print_card(struct card *c) {
  /* 1枚のカードをプリントする */
  char suit_name[4][10] = {"C", "D", "H", "S" };
  lcd.printf("%s%d", suit_name[c->suit], c->pips);
}

void print_deck(struct card deck[]) {
  /* 52枚のカードデッキをプリントする */
  int i;
  //printf("--BEGIN--");
  for (i = 0; i < 52; i++) {
    if (i % 4 == 0) {
      //printf("\n");
    }
    print_card(&deck[i]);
    //printf(" ");
  }
  //printf("\n--END--\n");
}

void print_hand(struct card h[]) {
  /* プレーヤ1人ぶんのカード5枚をプリントする */
  int i;
  for (i = 0; i < 5; i++) {
    print_card(&h[i]);// lcd.printf(" ");
  }
  //printf("\n");
}

void init_card(struct card deck[]) {
  /* 課題1 */
  int i;
  for(i=0; i<52; i++)
  {
    deck[i].suit=i/13;
    deck[i].pips=i%13+1;
  }
}

void shuffle(struct card deck[]) {
  /* 課題2 */
  int i,j;
  struct card tmp;
  for(i=0; i<52; i++) {
    j=rand()%52;
    tmp=deck[i];
    deck[i]=deck[j];
    deck[j]=tmp;
  }
}

void deal(struct card deck[], struct card hand[][5]) {
  /* 課題2 */
  int i,j,idx;
  idx=0;
  for(i=0; i<5; i++)
    for(j=0; j<NPLAYERS; j++)
      hand[j][i]=deck[idx++];
}

/* ヒント: この関数を使うと，判定が簡単かも */
void distrib(struct card h[], int dist[]) {
  int i;
  for (i = 0; i < 14; i++) {
    dist[i] = 0;
  }
  for (i = 0; i < 5; i++) {
    dist[h[i].pips]++;
  }
}

int is_straight(struct card h[]) {
  /* 課題3 */
  int dist[14],i=1;
  distrib(h,dist);
  while(i<10) {
    if(dist[i]) {
      if(dist[i+1] && dist[i+2] && dist[i+3] && dist[i+4]){
        return 1;
      }else{
        return 0;
      }
    }
    i++;
  }
  return 0;
}

int is_flush(struct card h[]) {
  /* 課題3 */
  int i;
  for(i=4; i; i--) {
    if(h[0].suit != h[i].suit) return 0;
  }
  return 1;
}

int is_fullhouse(struct card h[]) {
  /* 課題3 */
  int dist[14],i,flag=0;
  distrib(h,dist);
  for(i=1; i<14; i++) {
    switch(dist[i]) {
      case 0:
        break;
      case 2:
        if(flag&1) return 0;
        if(flag&2) return 1;
        flag |= 1;
        break;
      case 3:
        if(flag&1) return 1;
        flag |= 2;
        break;
      default:
        return 0;
    }
  }
}
