#include "mbed.h"
#include "Grove_LCD_RGB_Backlight.h"
#include "fftReal.hpp"

#define Nb_echantillons 256

//Elements
Grove_LCD_RGB_Backlight ecran(P0_27, P0_28);
AnalogIn micro(A1);

//Variables
Ticker echantillonage;
int sampling_freq = 44000;
float echantillons[Nb_echantillons*2];
int i = 0;
Mikami::Complex fft_bins[Nb_echantillons];
Mikami::FftReal fft((int16_t)Nb_echantillons);

void sampling_interrup()
{
    echantillons[i] = 1024*micro.read(); // 1024 : ADC of the sound sensor
    i++;
    if (i >= Nb_echantillons*2) {
        echantillonage.detach();
    }
}

void samplingBegin()
{
    // Reset sample buffer position and start callback at the sampling frequency
    i = 0;
    echantillonage.attach_us(&sampling_interrup, 1000000/sampling_freq);
}

bool samplingDone()
{
    return i >= Nb_echantillons*2;
}

void FFT(){
    char str[20];
    // max 1 is set to the second FFT bin, because the first bin has the DC componenet of the signal.
    int MAX = 2; 
    //int max2 = 3;
    float val = 0;
    /*ecran.locate(0, 0);
    sprintf(str,"Sampling done");
    ecran.print(str);
    wait(1);*/
    fft.Execute(echantillons,fft_bins);
    wait(0.5);
    
    /*ecran.clear();
    sprintf(str,"FFT Done");
    ecran.print(str);
    wait(1);*/
    
    // PRINT SPECTRUM
    for(int j = 0;j < Nb_echantillons/2 ;++j){
        ecran.clear();
        float mod = std::abs(fft_bins[j]);
        //float freq = j*sampling_freq/(Nb_echantillons*1000);
        /*sprintf(str,"%d.Freq = %.2f kHz", j,freq );
        ecran.locate(0,1);
        ecran.print(str);
        sprintf(str,"%d.Mag = %.2f", j, mod );
        ecran.locate(0,0);
        ecran.print(str);*/
        if( (j>5)and mod >= std::abs(fft_bins[MAX]) ){
            MAX = j;
        }
        /*else if ( (j>3) and (std::abs(fft_bins[j]) >= std::abs(fft_bins[max2])) and (std::abs(fft_bins[j]) < std::abs(fft_bins[MAX]))){
            max2 = j;
        }
        wait(1);*/
    }
    
    val = MAX*sampling_freq/(Nb_echantillons*1000);
    float mod = std::abs(fft_bins[MAX]);
    /*sprintf(str,"%MAX= %.2f", mod );
    ecran.locate(0,0);
    ecran.print(str);*/
    ecran.clear();
    sprintf(str,"max= %.2f kHz", val );
    ecran.locate(0,0);
    ecran.print(str);
    wait(2);
    /*val =  max2*sampling_freq/(Nb_echantillons*1000);
    sprintf(str,"max 2 = %.2f kHz", val);
    ecran.locate(0,1);
    ecran.print(str);
    wait(2);*/
    samplingBegin();
}

int main() {
    // CONFIG ECRAN
    ecran.setRGB(0, 255, 0);
    ecran.clear();
    ecran.locate(0, 1);
    samplingBegin();
    // The following loop, will do FFT and display highest detected frequency on the screen every 2s
    // Commented sections, are debug mode. If uncommented, it will do FFT, display all the  spectrum then restart, it will take about 10s + Nb_echantillons/2 seconds
    while(1) {
        // DO FFT
        if (samplingDone()) FFT();
        /* // DEBUG SCREEN
        ecran.clear();
        myled = !myled;
        sprintf(str,"Waiting ...");
        ecran.print(str);*/
    }
}
