/************************************************************************************/
/* axHTTP.h                                                                         */
/* �2013 Axeda Corporation                                                          */
/*                                                                                  */
/*Provides a basic, bare bones implementation of the HTTP 1.1 protocol spec to allow*/
/*this library to be more platform independent. The function calls in this file     */
/*depend on the socket calls provided in axTransport                                */
/*                                                                                  */
/************************************************************************************/
#ifndef AXHTTP_H
#define AXHTTP_H

#include "axTransport.h"

#define AX_HTTP_GET    0  //Standard GET Operation
#define AX_HTTP_POST   1  //Standard HTTP Post operation
#define AX_HTTP_MPOST  2  //Multipart form data operation, POST
#define AX_HTTP_PUT    3



typedef struct {
 // char *host; //..Host is passed in when sending to the
  char *contentType;
}HTTP_Headers;

typedef struct HTTP_Part{
   char *file_name;
   unsigned char *data;
   int data_sz;
   char *hint;
   struct HTTP_Part *next;
}HTTP_Part;

typedef struct {
    int operation;          //POST, GET, MPOST.
    char *resource;         //A pointer to a string that the resource is identified by
    HTTP_Headers headers;   //a structure of headers for the request
    char *body;             //the body of the request, used only for post and mpost
    int body_length;        //the length of the main body, used only for post and mpost
    HTTP_Part *mpData;      //the first link in a chain of data to be uploaded as part of a multipart post request
    int response_code;      //For responses only, this field will be populated after calling http_parse
    int secure;             //use SSL or TLS
}HTTP_Transmission;

//Flag used to turn on debug x-count header.
extern int http_debug;

//struct ax_socket; //incomplete declaration, see axTransport.h for full declaration

#ifdef __cplusplus 
  extern "C" {
#endif


//Operations
int http_send(HTTP_Transmission *request, char *host, int port, int secure, HTTP_Transmission *response);
int http_send_get(char *resource, char *host, int port, int secure, HTTP_Transmission *response);
int http_send_put(char *resource, char *host, int port, int secure, HTTP_Headers *headers, char *data, int data_sz, HTTP_Transmission *response);
int http_send_post(char *resource, char *host, int port, int secure, HTTP_Headers *headers, char *data, int data_sz, HTTP_Transmission *response);
int http_send_mpost(char *resource, char *host, int port, int secure, HTTP_Headers *headers, char *data, int data_sz, HTTP_Part *files, int part_ct, HTTP_Transmission *response);
void http_add_mpart(HTTP_Transmission *request, char *file_name, unsigned char *data, int file_sz); //For Future expansion, do not use.

//Return Handling
HTTP_Transmission *http_parse(HTTP_Transmission *response, char *data);

//Supporting Methods
char *http_getBoundary(char *buff, int length);
void zeroOutHTTPXmission(HTTP_Transmission *tgt);
char *createHeaders(char *tgtBuff, int http_operation, char *resource, int httpver, char *hostname, char *contentType, int contentLength, int xCount);

#ifdef __cplusplus
  }
#endif
#endif

