#ifndef _AXTYPES_H_
#define _AXTYPES_H_

#include "axSettings.h"


typedef struct ax_dataNode {
    char name[AX_DN_NAME_S];   
    char sValue[AX_DN_SV_S];
    double  dValue;
    int type;
    struct ax_dataNode* next;
}ax_dataNode;

typedef struct ax_dataNode axDataNode;

typedef struct {
    int acquisitionTime;
    int priority;
    int created;
    ax_dataNode *data_first;  
    ax_dataNode *data_last;
    int dataNode_ct;
}ax_dataSet;

typedef struct {
  char alarmName[AX_ALM_NAME_S];
  char alarmDescription[AX_ALM_DESC_S];
  int alarmSeverity;
  char alarmCause[AX_ALM_CAUSE_S];
  char alarmReason[AX_ALM_REAS_S];
  int dateAcquired;
  int priority;
}ax_alarm;   

typedef struct {
  char name[AX_EVT_NAME_S];
  char description[AX_EVT_DESC_S];
  int dateAcquired;
  int priority;
}ax_event;

typedef struct {
  double latitude;
  double longitude;
  double altitude;
  int dateAcquired;
  int priority;
}ax_location;

typedef struct { 
    char deviceId[AX_MSID_DID_S]; //Future expansion
    char model[AX_MSID_MDL_S];
    char serial[AX_MSID_SER_S];
    char tenant[AX_MSID_TEN_S];
}ax_deviceID;

//TODO: Possibly deprecate the ax_registration domain object which is just a ping rate and deviceID. Enforce it in the method.
typedef struct {
    ax_deviceID *device;
    int pingRate;
}ax_registration;

typedef struct { 
  char name[AX_FILE_NAME_S];
  char hint[AX_FILE_HINT_S];
  int size;
  char fileID[AX_FILE_ID_S];
  unsigned char *data; //array of bytes/ints/whatever
  //int priority;
}ax_file;

typedef struct {
    char hostname[AX_PLAT_HOST_S];
    int ip[4];
    int online;
    int port;
    int secure;         //Use SSL/TLS when talking to the platform.
    int ping_rate;
    int verify;         //a flag to verify the SSL/TLS certificate of the platform. The certificate MUST be stored locally and match otherwise the TLS handshake will fail.
}ax_platform;

typedef struct pkg_inst{
   int instruction_type; //mapped to the @type
   char file_id[AX_PKGI_FID_S];
   char path[AX_PKGI_PATH_S];
   char filename[AX_PKGI_FNAME_S];
   struct pkg_inst *next;
}ax_package_instruction;

typedef struct {
  char packageID[AX_PKG_ID_S];
  ax_package_instruction *instructions;
  int time;
  int priority;
}ax_package;


#endif

